Scriptname SuH_Fun extends Quest  

;	SuH_Fun : Function : is a global function holder for Succubus Heart. This script holds general functions to modify Succubus Heart, such as changing stats, processing animations, or just functions used across multiple scripts. This script can also be easily called for external mod integrations; if looking ot moddify Succubus Heart's functions, this is the first place to look.

SuH_Status property _s auto
Actor property PlayerRef auto
DialogueFollowerScript Property DialogueFollower Auto
Quest Property pDialogueFollower  Auto

;	Script Variables

;	KeyCode Values
int key_draintoggle
int key_arousalview
int key_petself
int key_drainkill
int title_checknum ; Defines which titles to check without using expensive strings

;	OnInit
;		initialize properites once we start
Event OnInit()
	InitProperties()
endEvent

;	Init Properties
;		Initialize properties
Function InitProperties()
	_s = Game.GetFormFromFile(0x16E496, "Succubus Heart.esp") as SuH_Status
	PlayerRef = _s.PlayerRef
	DialogueFollower = _s.DialogueFollower
	pDialogueFollower = _s.pDialogueFollower
endFunction

;	Keybindings
;		reset and register keycodes we're looking for
Function registerforkeybind()
	UnregisterForAllKeys()
	
	key_draintoggle = _s.SuH_KEY_draintoggle
	key_arousalview = _s.SuH_KEY_arousalview
	key_petself = _s.SuH_KEY_petself
	key_drainkill = _s.SuH_KEY_drainkilltoggle
	RegisterForKey(key_draintoggle)
	RegisterForKey(key_arousalview)
	RegisterForKey(key_petself)
	RegisterForKey(key_drainkill)
endFunction

;	On Key Press
;		when key registered in registerforkeybind() is pressed, run function associated with that keycode
Event OnKeyDown(Int KeyCode) ; OnKeyDown
	if KeyCode == key_draintoggle
		if (_s.SuH_SETnpcabsorb == 1)
			_s.SuH_SETnpcabsorb = 0
			debug.Notification("Disabled - Drain Affects NPC Status")
		else
			_s.SuH_SETnpcabsorb = 1
			debug.Notification("Enabled - Drain Affects NPC Status")
		endIf
	elseif KeyCode == key_drainkill
		if (_s.SuH_SETallowdrainkill == 1)
			_s.SuH_SETallowdrainkill = 0
			debug.Notification("Disabled - Allow Drain to Kill")
		else
			_s.SuH_SETallowdrainkill = 1
			debug.Notification("Enabled - Allow Drain to Kill")
		endIf
	elseif KeyCode == key_arousalview
		string arousalstatetext = ""
		int arousalstate = _s.SuH_PCSarousalstate
		if arousalstate == 0
			arousalstatetext = "Exhausted"
		elseif arousalstate == 1
			arousalstatetext = "Normal"
		elseif arousalstate == 2
			arousalstatetext = "Craving"
		elseif arousalstate == 3
			arousalstatetext = "Withrawl"
		elseif arousalstate == 4
			arousalstatetext = "Starved"
		endIf
		float x = _s.SuH_PCSarousal as float
		float y = _s.SuH_PCSarousaltarget as float
		int arousalpercentage = Math.Floor(((x + 1) / y) * 100)
		debug.Notification("Succubus Heart - Currently "+arousalstatetext+" - Arousal at "+arousalpercentage+"%")
	elseif KeyCode == key_petself
		_s.SuH_spell_petself.cast(_s.PlayerRef, _s.PlayerRef)
	endIf
endEvent

;	Title and Stat track calculator
; 		Called when performing certain actions that have an effect on titles, add the associated values via the stattracked string variable.
;		stattracked	: string	: string-based identifier for which action is being tracked to effect titles
;		addAmount	: int		: number of times to add to the tracked amount, not used by all tracked actions
;		title_checknum - value range to affect different titles, effectively a performance enhancement via manuall enumeration
;			Succubus Title		: 1-2-3
;			Fluid Drinker Title	: 2
;			Friendly Title		: 4-5
;			Pettrain			: 6
;			OfferItem			; 7
;			Seduced				; 8
Function PCE_stattrack(string stattracked = "", int addAmount = 0)
	title_checknum = 0
	;	Evolving
	if stattracked == "PCdraintarget"
		_s.SuH_titlexp_succubus += 1
		title_checknum = 1
	elseif stattracked == "PCconsumefluids"
		_s.SuH_titlexp_succubus += 5
		_s.SuH_titlexp_drinker += 20
		title_checknum = 2
	elseif stattracked == "Killdrain"
		_s.SuH_titlexp_succubus += 40
		title_checknum = 3
		if _s.SuH_title_drainkilled == 0
			_s.SuH_title_drainkilled = 1
			PC_addHeartXP(5000)
			Debug.Notification("Succubus Title Unlocked : "+PCE_gettitlename("Drainkilled")+" : +5000 HeartXP")
		endIf
	elseif stattracked == "Allyorgasm"
		_s.SuH_titlexp_friendly += 20
		title_checknum = 4
	elseif stattracked == "Giftedconsent"
		_s.SuH_titlexp_friendly += 2
		title_checknum = 5
	elseif stattracked == "Pettrainorg"
		_s.SuH_titlexp_pettrain += 40
		title_checknum = 6
	elseif stattracked == "OfferItem"
		_s.SuH_titlexp_offeritem += (5 * addAmount)
		title_checknum = 7
	elseif stattracked == "Seduced"
		_s.SuH_titlexp_seducer += (25)
		title_checknum = 8
	;	Secret
	elseif stattracked == "Pethit"
		if _s.SuH_title_pethit < 20
			_s.SuH_title_pethit += 1
			if _s.SuH_title_pethit > 19
				_s.SuH_PCSxp += 666
				Debug.Notification("Succubus Title Unlocked : "+PCE_gettitlename("Pethit")+" : +666 HeartXP")
			endIf
		endIf
	elseif stattracked == "Fedchest"
		if _s.SuH_title_fedchest < 10000
			_s.SuH_title_fedchest += addAmount
			if _s.SuH_title_fedchest > 9999
				_s.SuH_PCSxp += 5000
				Debug.Notification("Succubus Title Unlocked : "+PCE_gettitlename("Fedchest")+" : +5000 HeartXP")
			endIf
		endIf
	elseif stattracked == "Realmvisit"
		if _s.SuH_title_realmvisit == 0
			_s.SuH_title_realmvisit = 1
			_s.SuH_PCSxp += 2500
			Debug.Notification("Succubus Title Unlocked : "+PCE_gettitlename("Realmvisit")+" : +2500 HeartXP")
		endIf
	elseif stattracked == "Statdown"
		if _s.SuH_title_statdown == 0
			if _s.SuH_PCScaphealthdown > 332 && _s.SuH_PCScapmagickadown > 332 && _s.SuH_PCScapstaminadown > 332 ; if 333 or more
				_s.SuH_title_statdown = 1
				_s.SuH_PCSxp += 15000
				Debug.Notification("Succubus Title Unlocked : "+PCE_gettitlename("statdown")+" : +15000 HeartXP")
			endIf
		endIf
	endIf
	;	Check Titles with new count
	if title_checknum > 0 && title_checknum < 4 ; 1-2-3 Succubus Title
		if _s.SuH_title_succubus < 10000 ; if below cap
			int x = (_s.SuH_title_succubus * 100)
			if _s.SuH_titlexp_succubus >= x
				_s.SuH_titlexp_succubus -= x
				x = (1000 + (_s.SuH_title_succubus * 50))
				_s.SuH_PCSxp += x
				_s.SuH_title_succubus += 1
				Debug.Notification("Succubus Title Improved : "+PCE_gettitlename("Succubus")+" : +"+x+" HeartXP")
			endIf
		endIf
		if title_checknum == 2 && _s.SuH_title_drinker < 10000 ; 2 Fluid Drinker Title ; and below cap
			int x = (_s.SuH_title_drinker * 100)
			if _s.SuH_titlexp_drinker >= x
				_s.SuH_titlexp_drinker -= x
				x = (1000 + (_s.SuH_title_drinker * 50))
				_s.SuH_PCSxp += x
				_s.SuH_title_drinker += 1
				Debug.Notification("Succubus Title Improved : "+PCE_gettitlename("Drinker")+" : +"+x+" HeartXP")
			endIf
		endIf
	elseif title_checknum == 4 || title_checknum == 5 ; 4-5 Friendly Title
		if _s.SuH_title_friendly < 10000 ; if below cap
			int x = (_s.SuH_title_friendly * 100)
			if _s.SuH_titlexp_friendly >= x
				_s.SuH_titlexp_friendly -= x
				x = (1000 + (_s.SuH_title_friendly * 50))
				_s.SuH_PCSxp += x
				_s.SuH_title_friendly += 1
				Debug.Notification("Succubus Title Improved : "+PCE_gettitlename("Friendly")+" : +"+x+" HeartXP")
			endIf
		endIf
	elseif title_checknum == 6 && _s.SuH_title_pettrain < 10000 ; 6 Pettrain Title ; and below cap
		int x = (_s.SuH_title_pettrain * 100)
		if _s.SuH_titlexp_pettrain >= x
			_s.SuH_titlexp_pettrain -= x
			x = (1000 + (_s.SuH_title_pettrain * 50))
			_s.SuH_PCSxp += x
			_s.SuH_title_pettrain += 1
			Debug.Notification("Succubus Title Improved : "+PCE_gettitlename("Pettrain")+" : +"+x+" HeartXP")
		endIf
	elseif title_checknum == 7 && _s.SuH_title_offeritem < 10000
		int x = (_s.SuH_title_offeritem * 100)
		if _s.SuH_titlexp_offeritem >= x
			_s.SuH_titlexp_offeritem -= x
			x = (1000 + (_s.SuH_title_offeritem * 50))
			_s.SuH_PCSxp += x
			_s.SuH_title_offeritem += 1
			Debug.Notification("Succubus Title Improved : "+PCE_gettitlename("OfferItem")+" : +"+x+" HeartXP")
		endIf
	elseif title_checknum == 8 && _s.SuH_title_seducer < 10000
		int x = (_s.SuH_title_seducer * 100)
		if _s.SuH_titlexp_seducer >= x
			_s.SuH_titlexp_seducer -= x
			x = (1000 + (_s.SuH_title_seducer * 50))
			_s.SuH_PCSxp += x
			_s.SuH_title_seducer += 1
			Debug.Notification("Succubus Title Improved : "+PCE_gettitlename("Seduced")+" : +"+x+" HeartXP")
		endIf
	endIf
endFunction

;	Get Title Names
;		titletoget : string : title identifier to get the name of
string function PCE_gettitlename(string titletoget = "")
	;	Evolving Titles
	if titletoget == "Succubus"
		int x = _s.SuH_title_succubus
		if x > 80
			return("Elite Succubus")
		elseIf x > 40
			return("Great Succubus")
		elseIf x > 20
			return("Strong Succubus")
		elseIf x > 10
			return("Lesser Succubus")
		elseIf x > 0
			return("Weak Succubus")
		else
			return("[Unknown]")
		endIf
		
	elseif titletoget == "Drinker"
		int x = _s.SuH_title_drinker
		if x > 80
			return("Fluid Addict")
		elseIf x > 40
			return("Fluid Embracer")
		elseIf x > 20
			return("Fluid Enjoyer")
		elseIf x > 10
			return("Fluid Drinker")
		elseIf x > 0
			return("Fluid Tester")
		else
			return("[Unknown]")
		endIf
		
	elseif titletoget == "Friendly"
		int x = _s.SuH_title_friendly
		if x > 80
			return("Always Friendly")
		elseIf x > 40
			return("Often Friendly")
		elseIf x > 20
			return("Sometimes Friendly")
		elseIf x > 10
			return("Occasionally Friendly")
		elseIf x > 0
			return("Rarely Friendly")
		else
			return("[Unknown]")
		endIf
		
	elseif titletoget == "Pettrain"
		int x = _s.SuH_title_pettrain
		if x > 80
			return("Master Pet Trainer")
		elseIf x > 40
			return("Advanced Pet Trainer")
		elseIf x > 20
			return("Intermediate Pet Trainer")
		elseIf x > 10
			return("Amateur Pet Trainer")
		elseIf x > 0
			return("Beginner Pet Trainer")
		else
			return("[Unknown]")
		endIf
		
	elseif titletoget == "OfferItem"
		int x = _s.SuH_title_offeritem
		if x > 80
			return("Unmatched Gifter")
		elseIf x > 40
			return("Appraised Gifter")
		elseIf x > 20
			return("Appreciated Gifter")
		elseIf x > 10
			return("Passable Gifter")
		elseIf x > 0
			return("Underwhelming Gifter")
		else
			return("[Unknown]")
		endIf
		
	elseif titletoget == "Seduced"
		int x = _s.SuH_title_seducer
		if x > 80
			return("Irresistible Seducer")
		elseIf x > 40
			return("Alluring Seducer")
		elseIf x > 20
			return("Attractive Seducer")
		elseIf x > 10
			return("Interesting Seducer")
		elseIf x > 0
			return("Boring Seducer")
		else
			return("[Unknown]")
		endIf
		
	;	Secret Titles
	elseif titletoget == "Pethit"
		if _s.SuH_title_pethit < 20
			return("[Unknown]")
		else
			return("Physical Abuser of Pets")
		endIf
	elseif titletoget == "Realmvisit"
		if _s.SuH_title_realmvisit < 1
			return("[Unknown]")
		else
			return("Sevaniku Visitor")
		endIf
	elseif titletoget == "Drainkilled"
		if _s.SuH_title_drainkilled < 1
			return("[Unknown]")
		else
			return("Your Last Pleasure")
		endIf
	elseif titletoget == "Fedchest"
		if _s.SuH_title_fedchest < 10000
			return("[Unknown]")
		else
			return("Servant to the Gluttonous")
		endIf
	elseif titletoget == "Statdown"
		if _s.SuH_title_statdown < 1
			return("[Unknown]")
		else
			return("Passive Devil")
		endIf
	endIf
endFunction

;	Player Events

;	Player Succubus Orgasm Effect
;		Called when the player character has an orgasm to apply its effects
;		issolo : bool : is the act a solo act (masterbation)
Function PCE_orgasm(bool issolo = false)
	if issolo == true
		PC_addHeartXP((10 + (20 * (_s.SuH_PCSarousal / _s.SuH_PCSarousaltarget))))
	else
		PC_addHeartXP((20 + (50 * (_s.SuH_PCSarousal / _s.SuH_PCSarousaltarget))))
	endIf
	if _s.SuH_PCSarousal > _s.SuH_PCSarousaltarget ; if arrousal is above 100%
		PC_addArousal((Math.ceiling(-1*(_s.SuH_PCSarousaltarget * 0.75)))) ; Remove 75% of Arousal Target
	else ; if arousal is below 100%
		PC_addArousal(Math.ceiling(-1*(_s.SuH_PCSarousal * 0.6))) ; Remove 60% of current Arousal
	endIf
endFunction

;	Player Succubus Consume Sperm
;		Called when the player consumes Sperm
;		count : int : amount of sperm consumed at once (used to multiply the effect)
Function PCE_consumesperm(int count=1)
	PC_addHeartXP((20 * count))
	PC_addHealthMax(_s.SuH_PCSfluidhealth * count)
	PC_addMagickaMax(_s.SuH_PCSfluidmagicka * count)
	PC_addStaminaMax(_s.SuH_PCSfluidstamina * count)
	;	Luscious Liquids passive bonus
	if _s.SuH_rank_lusciousliquids > 0
		int x = Math.Floor(_s.SuH_rank_lusciousliquids * (_s.SuH_PCSdpoint * 0.1))
		int y = ((x + _s.SuH_PCSfluidhealth) * count)
		_s.PlayerRef.RestoreActorValue("Health", y)
		y = ((x + _s.SuH_PCSfluidmagicka) * count)
		_s.PlayerRef.RestoreActorValue("Magicka", y)
		y = ((x + _s.SuH_PCSfluidstamina) * count)
		_s.PlayerRef.RestoreActorValue("Stamina", y)
	endIf
	if _s.SuH_PCSarousalstate > 1 ; Reduce Arousal by a small amount if above Normal Arousal State
		int x = Math.Floor((((_s.SuH_PCSarousalstate - 1) * (_s.SuH_PCSarousaltarget *0.01)) * -1) * count) ; Reduce by 1% for each state above normal
		PC_addArousal(x)
	endIf
	PC_addFluidBonus( (Math.Floor((1000 * (1 + (0.5 * _s.SuH_rank_lusciousliquids2))) * count)) )
	PCE_stattrack("PCconsumefluids")
endFunction

;	Player Succubus Consume Breast Milk
;		Called when the player consumes Breast Milk
;		count : int : amount of breast milk consumed at once (used to multiply the effect)	
Function PCE_consumemilk(int count=1)
	PC_addHeartXP((20 * count))
	PC_addHealthMax(_s.SuH_PCSfluidhealth * count)
	PC_addMagickaMax(_s.SuH_PCSfluidmagicka * count)
	PC_addStaminaMax(_s.SuH_PCSfluidstamina * count)
	;	Luscious Liquids passive bonus
	if _s.SuH_rank_lusciousliquids > 0
		int x = Math.Floor(_s.SuH_rank_lusciousliquids * (_s.SuH_PCSdpoint * 0.1))
		int y = ((x + _s.SuH_PCSfluidhealth) * count)
		_s.PlayerRef.RestoreActorValue("Health", y)
		y = ((x + _s.SuH_PCSfluidmagicka) * count)
		_s.PlayerRef.RestoreActorValue("Magicka", y)
		y = ((x + _s.SuH_PCSfluidstamina) * count)
		_s.PlayerRef.RestoreActorValue("Stamina", y)
	endIf
	if _s.SuH_PCSarousalstate > 1 ; Reduce Arousal by a small amount if above Normal Arousal State
		int x = Math.Floor((((_s.SuH_PCSarousalstate - 1) * (_s.SuH_PCSarousaltarget *0.01)) * -1) * count) ; Reduce by 1% for each state above normal
		PC_addArousal(x)
	endIf
	PC_addFluidBonus( (Math.Floor((1000 * (1 + (0.5 * _s.SuH_rank_lusciousliquids2))) * count )) )
	PCE_stattrack("PCconsumefluids")
endFunction

;	Calculators

;	Add HeartXP
;		Adds HeartXP in a linear fashion, use this function when adding HeartXP that needs to be effected by XPmultipliers
;		xpamount		: int	: amount of HeartXP to add
;		xpmultiplier	: float	: additional multiplier to apply to the added amount which is added before the HeartXP gain setting
;		returns HeartXP amount added
int Function PC_addHeartXP(int xpamount = 0, float xpmultiplier = 0.0)
			; xpamount = heartXP to gain
			; xpmultiplier = flat multiplier to xpamount
			; PClevelscale = multiplier added per-level
			; 	Multipliers are addative, adding into a single value before being applied to XP gained
			;	Multipliers only effect positive values
	if xpamount > 0 ; if gain is positive
		int xptogain = Math.ceiling((xpamount * ((_s.SuH_PCSxpgain * 0.01) + xpmultiplier)) * _s.SuH_PCSeffectmulti)
		int x = (_s.SuH_PCSxp + xptogain)
		if x > 999999999 || x < 0 ; if avobe cap or overflow error
			_s.SuH_PCSxp = 999999999
		else
			_s.SuH_PCSxp += xptogain
		endIf
		return xptogain
	elseif xpamount < 0 ; if gain is negative
		int x = (_s.SuH_PCSxp + xpamount)
		if x < 0 || x > 999999999 ; if below 0 or overflow error
			_s.SuH_PCSxp = 0
		else
			_s.SuH_PCSxp += xpamount
		endIf
		return xpamount
	endIf
endFunction

;	Add Arousal
;		Adds arousal to the player, use this function when adding any arousal. Use SuH_PCSarousaltarget to determine how much arousal to add
;		addingArousal		: int	: how much arousal to add
;		ArousalMultiplier	: float	: additional arousal multiplier added to positive values, applied before arousal gain setting
Function PC_addArousal(int addingArousal, float ArousalMultiplier = 1.0)
	if addingArousal > 0 ; If possitive add gain multiplier from settings, else just add values normally
		int x = Math.ceiling(_s.SuH_PCSarousal + (addingArousal * ArousalMultiplier))
		int y = ((350 + (_s.SuH_rank_seducer2 * 20)) * (_s.SuH_PCSarousaltarget / 100)) ; define cap
		if x < y ; If under cap
			_s.SuH_PCSarousal += math.ceiling(addingArousal * (ArousalMultiplier * _s.SuH_PCSarousalgainmulti))
		else ; if above cap
			_s.SuH_PCSarousal = y
		endIf
	elseif addingArousal < 0 ; if negative
		int x = (_s.SuH_PCSarousal + addingArousal)
		if x < 0 || x > 999999999 ; if below 0 or overflow error
			_s.SuH_PCSarousal = 0
		else
			_s.SuH_PCSarousal += addingArousal
		endIf
	endIf
	
	PC_arousalState()
endFunction

;	Arousal State
;		Gets current arousal and calculates which arousal state the player is in
Function PC_arousalState()
	;	Get arousal percentage then apply the right state
	float x = _s.SuH_PCSarousal as float
	float y = _s.SuH_PCSarousaltarget as float
	int arousalpercentage = Math.Floor(((x + 1) / y) * 100)
	int seducerpassive = (_s.SuH_rank_seducer2 * 20)
	if arousalpercentage < 20 ; Exhausted
		if _s.SuH_PCSarousalstate != 0 ; if not current state
			_s.SuH_PCSarousalstate = 0 ; set state variable
			_s.playerRef.AddSpell(_s.SuH_arousal_0, false) ; apply spell
			_s.playerRef.RemoveSpell(_s.SuH_arousal_1) ; remove other spells
			_s.playerRef.RemoveSpell(_s.SuH_arousal_2)
			_s.playerRef.RemoveSpell(_s.SuH_arousal_3)
			_s.playerRef.RemoveSpell(_s.SuH_arousal_4)
			debug.Notification("Succubus Heart : Feeling Exhausted...")
		endIf
	elseif arousalpercentage < (120 + seducerpassive) ; Normal
		if _s.SuH_PCSarousalstate != 1
			_s.SuH_PCSarousalstate = 1
			_s.playerRef.AddSpell(_s.SuH_arousal_1, false)
			_s.playerRef.RemoveSpell(_s.SuH_arousal_0)
			_s.playerRef.RemoveSpell(_s.SuH_arousal_2)
			_s.playerRef.RemoveSpell(_s.SuH_arousal_3)
			_s.playerRef.RemoveSpell(_s.SuH_arousal_4)
			debug.Notification("Succubus Heart : Feeling Normal")
		endIf
	elseif arousalpercentage < (200 + seducerpassive) ; Craving
		if _s.SuH_PCSarousalstate != 2
			_s.SuH_PCSarousalstate = 2
			_s.playerRef.AddSpell(_s.SuH_arousal_2, false)
			_s.playerRef.RemoveSpell(_s.SuH_arousal_1)
			_s.playerRef.RemoveSpell(_s.SuH_arousal_0)
			_s.playerRef.RemoveSpell(_s.SuH_arousal_3)
			_s.playerRef.RemoveSpell(_s.SuH_arousal_4)
			debug.Notification("Succubus Heart : Having Some Cravings")
		endIf
	elseif arousalpercentage < (300 + seducerpassive) ; Withdrawl
		if _s.SuH_PCSarousalstate != 3
			_s.SuH_PCSarousalstate = 3
			_s.playerRef.AddSpell(_s.SuH_arousal_3, false)
			_s.playerRef.RemoveSpell(_s.SuH_arousal_1)
			_s.playerRef.RemoveSpell(_s.SuH_arousal_2)
			_s.playerRef.RemoveSpell(_s.SuH_arousal_0)
			_s.playerRef.RemoveSpell(_s.SuH_arousal_4)
			debug.Notification("Succubus Heart : Experiencing Withdrawl!")
		endIf
	else ; 300% and above - Starved
		if _s.SuH_PCSarousalstate != 4
			_s.SuH_PCSarousalstate = 4
			_s.playerRef.AddSpell(_s.SuH_arousal_4, false)
			_s.playerRef.RemoveSpell(_s.SuH_arousal_1)
			_s.playerRef.RemoveSpell(_s.SuH_arousal_2)
			_s.playerRef.RemoveSpell(_s.SuH_arousal_3)
			_s.playerRef.RemoveSpell(_s.SuH_arousal_0)
			debug.Notification("Saccvbish LIaurt ; Feal fahint....")
		endIf
	endIf
endFunction

;	Add SkillXP
;		Super basic function which adds SkillXP
Function PC_addSkillXP(int addAmount)
	_s.SuH_PCSskillxp += addAmount
endFunction

;	Get HeartXP Cost
;		Returns the current cost for the designated skill name
;	skillID	: int	: Skill's ID as defined by this function
;	lvldif	: int	: Level difference to calculate, ex. set -1 to get the previous level or +1 to get next level cost, used in refund calculation

int Function PC_getHeartXPcost(string skillID, int lvldif=0)
	if skillID == "capHealth" ; Health Cap
		return Math.Floor((((_s.SuH_PCScaphealth + _s.SuH_PCScaphealthdown - _s.SuH_PCScaphealthitem) + lvldif) * 0.18 * 15) - 80)
	elseif skillID == "capMagicka" ; Magicka Cap
		return Math.Floor((((_s.SuH_PCScapmagicka + _s.SuH_PCScapmagickadown - _s.SuH_PCScapmagickaitem) + lvldif) * 0.18 * 15) - 80)
	elseif skillID == "capStamina" ; Stamina Cap
		return Math.Floor((((_s.SuH_PCScapstamina + _s.SuH_PCScapstaminadown - _s.SuH_PCScapstaminaitem) + lvldif) * 0.18 * 15) - 80)
	elseif skillID == "capEffect" ; effective cap
		return Math.Floor((_s.SuH_PCScaplevel + 1 + lvldif) * 4.2 * 360)
	elseif skillID == "absorbHealth" ; health absorption
		return Math.Floor((_s.SuH_PCSabsorbhealth + lvldif) * 2.2 * 280)
	elseif skillID == "absorbMagicka" ; magicka absorption
		return Math.Floor((_s.SuH_PCSabsorbmagicka + lvldif) * 2.2 * 280)
	elseif skillID == "absorbStamina" ; stamina absorption
		return Math.Floor((_s.SuH_PCSabsorbstamina + lvldif) * 2.2 * 280)
	elseif skillID == "fluidHealth" ; fluid health bonus
		return Math.Floor((_s.SuH_PCSfluidhealth + lvldif) * 1.8 * 210)
	elseif skillID == "fluidMagicka" ; fluid magicka bonus
		return Math.Floor((_s.SuH_PCSfluidmagicka + lvldif) * 1.8 * 210)
	elseif skillID == "fluidStamina" ; fluid stamina bonus
		return Math.Floor((_s.SuH_PCSfluidstamina + lvldif) * 1.8 * 210)
	elseif skillID == "xpGain"
		return Math.Floor(((_s.SuH_PCSxpgain - (99+_s.SuH_PCSxpgainitem) + lvldif) * 2.0 * 350) *0.5)
	elseif skillID == "sexBonus"
		return  Math.Floor(((_s.SuH_PCSsexbonusmax / 500) - 9 + lvldif) * 2.8 * 240) ; 5000 default max, -9 so we get 1 at starting level
	elseif skillID == "fluidBonus"
		return Math.Floor(((_s.SuH_PCSfluidbonusmax / 500) - 9 + lvldif) * 2.8 * 240)
	elseif skillID == "BDSMrank"
		return Math.Floor((1200 * (_s.SuH_rank_bdsm + lvldif)) * 1.6 + 1200)
	endIf
endFunction

;	Get SkillXP Cost
;		Returns the current cost for the designated actorValue
;	actorValue	: string	: Actor value we're checking, no error checking so must be a Skill for valid return results
int Function PC_getSkillXPcost(string actorValue)
	return Math.Ceiling((_s.playerRef.GetBaseActorValue(actorValue)*0.3)*150)
endFunction

;	Add Sex Bonus
;		Adds Sex Bonus to the player
;		addAmount		: int	: Amount of Sex Bonus to add, use SuH_PCSsexbonushour to determine how much to add
;		addMultiplier	: float	: additional multiplier to apply to positive values
Function PC_addSexBonus(int addAmount, float addMultiplier = 1.0)
	if addAmount > 0 ; If possitive add gain multiplier from settings, else just add values normally
		int x = Math.ceiling( (_s.SuH_PCSsexbonus + (addAmount * addMultiplier)) * (_s.SuH_PCSsexbonusadd * 0.01) )
		if x < _s.SuH_PCSsexbonusmax ; if under cap
			_s.SuH_PCSsexbonus += Math.ceiling( (_s.SuH_PCSsexbonus + (addAmount * addMultiplier)) * (_s.SuH_PCSsexbonusadd * 0.01) )
		else
			_s.SuH_PCSsexbonus = _s.SuH_PCSsexbonusmax
		endIf
	elseif addAmount < 0 ; if negative
		int x = (_s.SuH_PCSsexbonus + addAmount)
		if x < 0 || x > 999999999 ; if below 0 or overflow error
			_s.SuH_PCSsexbonus = 0
		else
			_s.SuH_PCSsexbonus += addAmount
		endIf
	endIf
endFunction

;	Add Fluid Bonus
;		Adds Fluid Bonus to the player
;		addAmount		: int	: Amount of Fluid Bonus to add, use SuH_PCSfluidbonushour to determine how much to add
;		addMultiplier	: float	: additional multiplier to apply to positive values
Function PC_addFluidBonus(int addAmount, float addMultiplier = 1.0)
	if addAmount > 0 ; If possitive add gain multiplier from settings, else just add values normally
		int x = Math.ceiling( (_s.SuH_PCSfluidbonus + (addAmount * addMultiplier)) * (_s.SuH_PCSfluidbonusadd * 0.01) )
		if x < _s.SuH_PCSfluidbonusmax ; if under cap
			_s.SuH_PCSfluidbonus += Math.ceiling( (_s.SuH_PCSfluidbonus + (addAmount * addMultiplier)) * (_s.SuH_PCSfluidbonusadd * 0.01) )
		else
			_s.SuH_PCSfluidbonus = _s.SuH_PCSfluidbonusmax
		endIf
	elseif addAmount < 0 ; if negative
		int x = (_s.SuH_PCSfluidbonus + addAmount)
		if x < 0 || x > 999999999 ; if below 0 or overflow error
			_s.SuH_PCSfluidbonus = 0
		else
			_s.SuH_PCSfluidbonus += addAmount
		endIf
	endIf
endFunction

;	Player Succubus Validate Max Status
;		Checks the current player max status values and compares them to status caps, apply effects as needed such as status decay when over cap
Function PC_checkstatusmax() ; Check Max Status
	int statCap = _s.SuH_PCScaphealth ; Cap provided by status
	int statCapActual = (100 + ((6 + _s.SuH_PCScaplevel) * _s.playerRef.GetLevel())) ; Actual Cap by level
	if statCap > statCapActual
		statCap = statCapActual ; truncate to statCapActual if above
	endIf
	int xv = Math.Floor(_s.playerRef.GetBaseActorValue("Health"))
	if xv > statCap
		xv = Math.Floor(((xv - statCap) * 0.05) * -1) ; get 5 percent
		if xv > -1
			xv = -1
		endIf
		PC_addHealthMax(xv, skillXPconvert=true) ; decay max status if above cap
	endIf
	statCap = _s.SuH_PCScapmagicka ; Cap provided by status
	if statCap > statCapActual
		statCap = statCapActual ; truncate to statCapActual if above
	endIf
	xv = Math.Floor(_s.playerRef.GetBaseActorValue("Magicka"))
	if xv > statCap
		xv = Math.Floor(((xv - statCap) * 0.05) * -1) ; get 5 percent
		if xv > -1
			xv = -1
		endIf
		PC_addMagickaMax(-1, skillXPconvert=true)
	endIf
	statCap = _s.SuH_PCScapstamina ; Cap provided by status
	if statCap > statCapActual
		statCap = statCapActual ; truncate to statCapActual if above
	endIf
	xv = Math.Floor(_s.playerRef.GetBaseActorValue("Stamina"))
	if xv > statCap
		xv = Math.Floor(((xv - statCap) * 0.05) * -1) ; get 5 percent
		if xv > -1
			xv = -1
		endIf
		PC_addStaminaMax(-1, skillXPconvert=true)
	endIf
endFunction


;	Add Max Health
;		Adds max health to the Player Succubus while respecting status caps, apply benefits similar to PC_checkstatusmax when over the cap
;		addAmount		: int	: Max Health amount to add
;		skillXPconvert	: bool	: If we should convert status obove the cap into SkillXP, or do nothing with it if false
Function PC_addHealthMax(int addAmount, bool skillXPconvert = false)
	if addAmount > 0 ; if positive
		;	Get player funtional cap
		int statCap = _s.SuH_PCScaphealth ; Cap provided by status
		int statCapActual = (100 + ((6 + _s.SuH_PCScaplevel) * _s.playerRef.GetLevel())) ; Actual Cap by level
		if statCap > statCapActual
			statCap = statCapActual ; truncate to statCapActual if above
		endIf
		if _s.SuH_rank_capexcel > 0 ; Cap Excel Passive
			statCap += Math.Floor((_s.SuH_PCSbpoint * 0.2) * _s.SuH_rank_capexcel)
		endIf
		int playerstat = Math.Floor(playerRef.GetBaseActorValue("Health"))
		if playerstat >= statCap ; If already at cap
			return
		else ; if not already at cap
			int statMax = (playerstat + addAmount) ; Get new max status to check against cap
			if statMax > statCap ; if end result is above cap
				PC_addSkillXP( (statMax - statCap) ) ; Add Skill XP for absorb past cap
				playerRef.SetActorValue("Health", statCap)
			elseif statMax < 0 ; check for overflow error
				playerRef.SetActorValue("Health", statCap)
			else ; end result not above cap
				PlayerRef.SetActorValue("Health", (playerstat + addAmount))
			endIf
		endIf
	elseif addAmount < 0 ; if negative
		int maxstatstart = Math.Floor(PlayerRef.GetBaseActorValue("Health")) ; get current base
		if maxstatstart > 1 ; If status above 1 and can decrease
			if maxstatstart > (-1 * addAmount) ; if enough to decrease full amount
				playerRef.SetActorValue("Health", (Math.Floor(playerRef.GetBaseActorValue("Health") + addAmount)))
				if skillXPconvert == true
					PC_addSkillXP( (-1 * addAmount) )
				endIf
			else ; not enough for full amount
				if skillXPconvert == true && PlayerRef.GetBaseActorValue("Health") > 1
					PC_addSkillXP( (Math.Floor(PlayerRef.GetBaseActorValue("Health") - 1)) )
				endIf
				PlayerRef.SetActorValue("Health", 1)
			endIf
		endIf
	endIf
endFunction

;	Add Max Magicka
Function PC_addMagickaMax(int addAmount, bool skillXPconvert = false)
	if addAmount > 0 ; if positive
		;	Get player funtional cap
		int statCap = _s.SuH_PCScapmagicka ; Cap provided by status
		int statCapActual = (100 + ((6 + _s.SuH_PCScaplevel) * _s.playerRef.GetLevel())) ; Actual Cap by level
		if statCap > statCapActual
			statCap = statCapActual ; truncate to statCapActual if above
		endIf
		if _s.SuH_rank_capexcel > 0 ; Cap Excel Passive
			statCap += Math.Floor((_s.SuH_PCSbpoint * 0.2) * _s.SuH_rank_capexcel)
		endIf
		int playerstat = Math.Floor(playerRef.GetBaseActorValue("Magicka"))
		if playerstat >= statCap ; If already at cap
			return
		else ; if not already at cap
			int statMax = Math.Floor(playerstat + addAmount) ; Get new max status to check against cap
			if statMax > statCap ; if end result is above cap
				PC_addSkillXP( (statMax - statCap) ) ; Add Skill XP for absorb past cap
				playerRef.SetActorValue("Magicka", statCap)
			elseif statMax < 0 ; check for overflow error
				playerRef.SetActorValue("Magicka", statCap)
			else ; end result not above cap
				PlayerRef.SetActorValue("Magicka", (playerstat + addAmount))
			endIf
		endif
	elseif addAmount < 0 ; if negative
		int maxstatstart = Math.Floor(PlayerRef.GetBaseActorValue("Magicka")) ; get current base
		if maxstatstart > 1 ; If status above 1 and can decrease
			if maxstatstart > addAmount ; if enough to decrease full amount
				playerRef.SetActorValue("Magicka", (Math.Floor(playerRef.GetBaseActorValue("Magicka") + addAmount)))
				if skillXPconvert == true
					PC_addSkillXP( (addAmount * -1) )
				endIf
			else ; not enough for full amount
				if skillXPconvert == true && PlayerRef.GetBaseActorValue("Magicka") > 1
					PC_addSkillXP( (Math.Floor(PlayerRef.GetBaseActorValue("Magicka") - 1)) )
				endIf
				PlayerRef.SetActorValue("Magicka", 1)
			endIf
		endIf
	endIf
endFunction

;	Add Max Stamina
Function PC_addStaminaMax(int addAmount, bool skillXPconvert = false)
	if addAmount > 0 ; if positive
		;	Get player funtional cap
		int statCap = _s.SuH_PCScapstamina ; Cap provided by status
		int statCapActual = (100 + ((6 + _s.SuH_PCScaplevel) * _s.playerRef.GetLevel())) ; Actual Cap by level
		if statCap > statCapActual
			statCap = statCapActual ; truncate to statCapActual if above
		endIf
		if _s.SuH_rank_capexcel > 0 ; Cap Excel Passive
			statCap += Math.Floor((_s.SuH_PCSbpoint * 0.2) * _s.SuH_rank_capexcel)
		endIf
		int playerstat = Math.Floor(playerRef.GetBaseActorValue("Stamina"))
		if playerstat >= statCap ; If already at cap
			return
		else ; if not already at cap
			int statMax = (playerstat + addAmount) ; Get new max status to check against cap
			if statMax > statCap ; if end result is above cap
				PC_addSkillXP( (statMax - statCap) ) ; Add Skill XP for absorb past cap
				playerRef.SetActorValue("Stamina", statCap)
			elseif statMax < 0 ; check for overflow error
				playerRef.SetActorValue("Stamina", statCap)
			else ; end result not above cap
				PlayerRef.SetActorValue("Stamina", (playerstat + addAmount))
			endIf
		endif
	elseif addAmount < 0 ; if negative
		int maxstatstart = Math.Floor(PlayerRef.GetBaseActorValue("Stamina")) ; get current base
		if maxstatstart > 1 ; If status above 1 and can decrease
			if maxstatstart > addAmount ; if enough to decrease full amount
				playerRef.SetActorValue("Stamina", (Math.Floor(playerRef.GetBaseActorValue("Stamina") + addAmount)))
				if skillXPconvert == true
					PC_addSkillXP( (addAmount * -1) )
				endIf
			else ; not enough for full amount
				if skillXPconvert == true && PlayerRef.GetBaseActorValue("Stamina") > 1
					PC_addSkillXP( (Math.Floor(PlayerRef.GetBaseActorValue("Stamina") - 1)) )
				endIf
				PlayerRef.SetActorValue("Stamina", 1)
			endIf
		endIf
	endIf
endFunction

;	Drain Health Status
;		Manages drain on a target, respecting player caps and settings. Can be ran with NPCs as the benefactor, even if the mod doesn't natively use it
;		drainAmount			: int	: amount of Max Status to drain from the actorTakeFrom and given to actorGiveTo
;		actorGiveTo			: actor	: Actor that recieves the drained status, the benefactor
;		actorTakeFrom		: actor	: Actor to take the status from, the target to drain
;		drainMultiplier		: float	: Additional multiplier to add to the drained amount
;		doNotReduceStatus	: bool	: When true this will prevent status from being drained from actorTakeFrom, settings overwrite this value
;			Only use this variable to ensure status isn't drained if that is a requirement
Function drainStat_Health(int drainAmount, actor actorGiveTo, actor actorTakeFrom, float drainMultiplier = 1.0, bool doNotReduceStatus=false)
	if _s.SuH_SETnpcabsorb == 0 && _s.SuH_SETalwaysabsorbbenefit > 0 && actorGiveTo == playerRef ; If always gain drain benefit is enabled with player as draining character
		doNotReduceStatus = true
	elseif _s.SuH_SETnpcabsorb == 0 || actorTakeFrom == none || actorGiveTo == none || actorTakeFrom.IsInFaction(_s.SuH_ignoreabsorb) || actorTakeFrom == playerRef || actorTakeFrom.IsInFaction(_s.SuH_Succubus) ; if either actor isn't found, or actorTakeFrom is immune/player, end function
		return
	elseif _s.SuH_SETnpcabsorb == 2 && actorTakeFrom.GetRelationshipRank(actorGiveTo) >= 3 ; If draining an ally while draining allies is disabled
		if _s.SuH_SETalwaysabsorbbenefit > 0 ; If we get drain benefits anyways
			doNotReduceStatus = true
		else
			return
		endIf
	endIf
	int actortakestat = Math.Floor(actorTakeFrom.GetBaseActorValue("Health"))
	if actortakestat > 1 ; If stat isn't at minimum / Completely drained
		if actortakestat > drainAmount ; If has enough for full drian amount, take drain amount
			if doNotReduceStatus == false
				actorTakeFrom.SetActorValue("Health", (actorTakeFrom.GetBaseActorValue("Health") - drainAmount) )
			endIf
			if actorGiveTo == PlayerRef ; if player get stat
				PC_addHealthMax(drainAmount)
				int x = Math.ceiling(drainAmount + (drainAmount * (_s.SuH_rank_healthyabsorber * 0.25)))
				actorGiveTo.RestoreActorValue("Health", x)
				_s.SuH_PCSdraincount += 1
			else ; if npc get stat
				actorGiveTo.SetActorValue("Health", (actorGiveTo.GetBaseActorValue("Health") + drainAmount) )
				actorGiveTo.RestoreActorValue("Health", drainAmount)
			endIf
		else ; Drain to minimum / completely drain
			int maxdrainamount = Math.Floor(actorTakeFrom.GetBaseActorValue("Health") - 1.0)
			if doNotReduceStatus == false
				actorTakeFrom.SetActorValue("Health", 1.0)
			endIf
			if actorGiveTo == PlayerRef ; if player get stat
				if _s.SuH_SETalwaysabsorbbenefit > 0
					maxdrainamount = drainAmount
				endIf
				PC_addHealthMax(maxdrainamount)
				int x = Math.ceiling(maxdrainamount + (maxdrainamount * (_s.SuH_rank_healthyabsorber * 0.25)))
				actorGiveTo.RestoreActorValue("Health", x)
				_s.SuH_PCSdraincount += 1
			else ; if npc get stat
				actorGiveTo.SetActorValue("Health", (actorGiveTo.GetBaseActorValue("Health") + maxdrainamount) )
				actorGiveTo.RestoreActorValue("Health", drainAmount)
			endIf
		endIf
	elseif actorGiveTo == PlayerRef && _s.SuH_SETalwaysabsorbbenefit > 0
		PC_addHealthMax(drainAmount)
		_s.SuH_PCSdraincount += 1
	endIf
endFunction

;	Drain Magicka Status
Function drainStat_Magicka(int drainAmount, actor actorGiveTo, actor actorTakeFrom, float drainMultiplier = 1.0, bool doNotReduceStatus=false)
	if _s.SuH_SETnpcabsorb == 0 && _s.SuH_SETalwaysabsorbbenefit > 0 && actorGiveTo == playerRef ; If always gain drain benefit is enabled with player as draining character
		doNotReduceStatus = true
	elseif _s.SuH_SETnpcabsorb == 0 || actorTakeFrom == none || actorGiveTo == none || actorTakeFrom.IsInFaction(_s.SuH_ignoreabsorb) || actorTakeFrom == playerRef || actorTakeFrom.IsInFaction(_s.SuH_Succubus) ; if either actor isn't found, or actorTakeFrom is immune/player, end function
		return
	elseif _s.SuH_SETnpcabsorb == 2 && actorTakeFrom.GetRelationshipRank(actorGiveTo) >= 3 ; If draining an ally while draining allies is disabled
		if _s.SuH_SETalwaysabsorbbenefit > 0 ; If we get drain benefits anyways
			doNotReduceStatus = true
		else
			return
		endIf
	endIf
	int actortakestat = Math.Floor(actorTakeFrom.GetBaseActorValue("Magicka"))
	if actortakestat > 1 ; If stat isn't at minimum / Completely drained
		if actortakestat > drainAmount ; If has enough for full drian amount, take drain amount
			if doNotReduceStatus == false
				actorTakeFrom.SetActorValue("Magicka", (actorTakeFrom.GetBaseActorValue("Magicka") - drainAmount) )
			endIf
			if actorGiveTo == PlayerRef ; if player get stat
				PC_addMagickaMax(drainAmount)
				int x = Math.ceiling(drainAmount + (drainAmount * (_s.SuH_rank_healthyabsorber * 0.25)))
				actorGiveTo.RestoreActorValue("Magicka", x)
				_s.SuH_PCSdraincount += 1
			else ; if npc get stat
				actorGiveTo.SetActorValue("Magicka", (actorGiveTo.GetBaseActorValue("Magicka") + drainAmount) )
				actorGiveTo.RestoreActorValue("Magicka", drainAmount)
			endIf
		else ; Drain to minimum / completely drain
			int maxdrainamount = Math.Floor(actorTakeFrom.GetBaseActorValue("Magicka"))
			if doNotReduceStatus == false
				actorTakeFrom.SetActorValue("Magicka", 0.0)
			endIf
			if actorGiveTo == PlayerRef ; if player get stat
				if _s.SuH_SETalwaysabsorbbenefit > 0
					maxdrainamount = drainAmount
				endIf
				PC_addMagickaMax(maxdrainamount)
				int x = Math.ceiling(maxdrainamount + (maxdrainamount * (_s.SuH_rank_healthyabsorber * 0.25)))
				actorGiveTo.RestoreActorValue("Magicka", x)
				_s.SuH_PCSdraincount += 1
			else ; if npc get stat
				actorGiveTo.SetActorValue("Magicka", (actorGiveTo.GetBaseActorValue("Magicka") + maxdrainamount) )
				actorGiveTo.RestoreActorValue("Magicka", drainAmount)
			endIf
		endIf
	elseif actorGiveTo == PlayerRef && _s.SuH_SETalwaysabsorbbenefit > 0
		PC_addMagickaMax(drainAmount)
		_s.SuH_PCSdraincount += 1
	endIf
endFunction

;	Drain Stamina Status
Function drainStat_Stamina(int drainAmount, actor actorGiveTo, actor actorTakeFrom, float drainMultiplier = 1.0, bool doNotReduceStatus=false)
	if _s.SuH_SETnpcabsorb == 0 && _s.SuH_SETalwaysabsorbbenefit > 0 && actorGiveTo == playerRef ; If always gain drain benefit is enabled with player as draining character
		doNotReduceStatus = true
	elseif _s.SuH_SETnpcabsorb == 0 || actorTakeFrom == none || actorGiveTo == none || actorTakeFrom.IsInFaction(_s.SuH_ignoreabsorb) || actorTakeFrom == playerRef || actorTakeFrom.IsInFaction(_s.SuH_Succubus) ; if either actor isn't found, or actorTakeFrom is immune/player, end function
		return
	elseif _s.SuH_SETnpcabsorb == 2 && actorTakeFrom.GetRelationshipRank(actorGiveTo) >= 3 ; If draining an ally while draining allies is disabled
		if _s.SuH_SETalwaysabsorbbenefit > 0 ; If we get drain benefits anyways
			doNotReduceStatus = true
		else
			return
		endIf
	endIf
	int actortakestat = Math.Floor(actorTakeFrom.GetBaseActorValue("Stamina"))
	if actortakestat > 1 ; If stat isn't at minimum / Completely drained
		if actortakestat > drainAmount ; If has enough for full drian amount, take drain amount
			if doNotReduceStatus == false
				actorTakeFrom.SetActorValue("Stamina", (actorTakeFrom.GetBaseActorValue("Stamina") - drainAmount) )
			endIf
			if actorGiveTo == PlayerRef ; if player get stat
				PC_addStaminaMax(drainAmount)
				int x = Math.ceiling(drainAmount + (drainAmount * (_s.SuH_rank_healthyabsorber * 0.25)))
				actorGiveTo.RestoreActorValue("Stamina", x)
				_s.SuH_PCSdraincount += 1
			else ; if npc get stat
				actorGiveTo.SetActorValue("Stamina", (actorGiveTo.GetBaseActorValue("Stamina") + drainAmount) )
				actorGiveTo.RestoreActorValue("Stamina", drainAmount)
			endIf
		else ; Drain to minimum / completely drain
			int maxdrainamount = Math.Floor(actorTakeFrom.GetBaseActorValue("Stamina"))
			if doNotReduceStatus == false
				actorTakeFrom.SetActorValue("Stamina", 0.0)
			endIf
			if actorGiveTo == PlayerRef ; if player get stat
				if _s.SuH_SETalwaysabsorbbenefit > 0
					maxdrainamount = drainAmount
				endIf
				PC_addStaminaMax(maxdrainamount)
				int x = Math.ceiling(maxdrainamount + (maxdrainamount * (_s.SuH_rank_healthyabsorber * 0.25)))
				actorGiveTo.RestoreActorValue("Stamina", x)
				_s.SuH_PCSdraincount += 1
			else ; if npc get stat
				actorGiveTo.SetActorValue("Stamina", (actorGiveTo.GetBaseActorValue("Stamina") + maxdrainamount) )
				actorGiveTo.RestoreActorValue("Stamina", drainAmount)
			endIf
		endIf
	elseif actorGiveTo == PlayerRef && _s.SuH_SETalwaysabsorbbenefit > 0
		PC_addStaminaMax(drainAmount)
		_s.SuH_PCSdraincount += 1
	endIf
endFunction

;	Add Health Down
;		Called when passives are learned to reduce Status Caps, use this to ensure consistency and prevent reset errors
Function PC_addHealthDown(int addAmount)
	_s.SuH_PCScaphealthdown += addAmount
	_s.SuH_PCScaphealth -= addAmount
	PCE_stattrack("Statdown")
endFunction

;	Add Magicka Down
Function PC_addMagickaDown(int addAmount)
	_s.SuH_PCScapmagickadown += addAmount
	_s.SuH_PCScapmagicka -= addAmount
	PCE_stattrack("Statdown")
endFunction

;	Add Stamina Down
Function PC_addStaminaDown(int addAmount)
	_s.SuH_PCScapstaminadown += addAmount
	_s.SuH_PCScapstamina -= addAmount
	PCE_stattrack("Statdown")
endFunction

;	Recalculate BDSM Rating
;		Recalculates BDSM values
;		isreset : bool : is this ran with a passive reset, currently unused
function PC_recalculateBDSM(bool isreset = false)
	;	Body Points Calculation
	_s.SuH_PCSbpoint = Math.Floor( ((_s.SuH_PCScaphealth + _s.SuH_PCScaphealthdown) - 100 - _s.SuH_PCScaphealthitem) + ((_s.SuH_PCSabsorbhealth - 1)*5) + ((_s.SuH_PCSfluidhealth - 1)* 4) + (_s.SuH_rank_bdsm * 5) + (_s.SuH_PCScaplevel * 2) )
	;	Desire Points Calculation
	_s.SuH_PCSdpoint = Math.Floor( ((_s.SuH_PCSsexbonusmax / 100) - 50) + ((_s.SuH_PCSfluidbonusmax / 100) - 50) + ( ((_s.SuH_PCSxpgain - (100 + _s.SuH_PCSxpgainitem)) / 2) * 10 ) + (_s.SuH_rank_bdsm * 5) )
	;	Soul Points Calculation
	_s.SuH_PCSspoint = Math.Floor( ((_s.SuH_PCScapstamina + _s.SuH_PCScapstaminadown) - 100 - _s.SuH_PCScapstaminaitem) + ((_s.SuH_PCSabsorbstamina - 1)*5) + ((_s.SuH_PCSfluidstamina - 1)* 4) + (_s.SuH_rank_bdsm * 5) + (_s.SuH_PCScaplevel * 2) )
	;	Mind Points Calculation
	_s.SuH_PCSmpoint = Math.Floor( ((_s.SuH_PCScapmagicka + _s.SuH_PCScapmagickadown) - 100 - _s.SuH_PCScapmagickaitem) + ((_s.SuH_PCSabsorbmagicka - 1)*5) + ((_s.SuH_PCSfluidmagicka - 1)* 4) + (_s.SuH_rank_bdsm * 5) + (_s.SuH_PCScaplevel * 2) )
	;	Combined Points
	_s.SuH_PCSbdsm = (_s.SuH_PCSbpoint+_s.SuH_PCSdpoint+_s.SuH_PCSspoint+_s.SuH_PCSmpoint)
endFunction

;	Passive Reset
;		Resets all passives and returns reduced status
;		freereset : int : if above 0 we won't reduce HeartXP as the cost, making the reset free
Function PassiveReset(int freereset= 0)
	int passiveresetcost = (playerRef.GetLevel() * 200)
	if freereset != 0 || _s.SuH_SETfreepassivereset
		passiveresetcost = 0
	endIf
	if _s.SuH_PCSxp >= passiveresetcost
		_s.SuH_PCSxp -= passiveresetcost
		
		_s.SuH_rank_deviouspartner = 0
		_s.SuH_rank_deviouspartner2 = 0
		_s.SuH_rank_forcemaster = 0
		_s.SuH_rank_formalbeauty = 0
		_s.SuH_rank_formalbeauty2 = 0
		_s.SuH_rank_giftedconsent = 0
		_s.SuH_rank_giftedconsentplus = 0
		_s.SuH_rank_healthyabsorber = 0
		_s.SuH_rank_lusciousliquids = 0
		_s.SuH_rank_lusciousliquids2 = 0
		_s.SuH_rank_masochist = 0
		_s.SuH_rank_masochist2 = 0
		_s.SuH_rank_masochist3 = 0
		_s.SuH_rank_perfectorgasm = 0
		_s.SuH_rank_perfectorgasm2 = 0
		_s.SuH_rank_regalglow = 0
		_s.SuH_rank_savingessence = 0
		_s.SuH_rank_savingessence2 = 0
		_s.SuH_rank_seducer = 0
		_s.SuH_rank_seducer2 = 0
		_s.SuH_rank_violence = 0
		_s.SuH_rank_violence2 = 0
		_s.SuH_rank_violence3 = 0
		_s.SuH_rank_capexcel = 0
		_s.SuH_rank_capexcel2 = 0
		_s.SuH_rank_capexcelplus = 0
		_s.SuH_rank_selfstacker = 0
		_s.SuH_rank_selfstackerplus = 0
		_s.SuH_rank_soultap = 0
		_s.SuH_rank_soultapplus = 0
		_s.SuH_rank_sexualentice = 1
		_s.SuH_rank_sexualenrage = 1
		_s.SuH_PCScaphealth += _s.SuH_PCScaphealthdown
		_s.SuH_PCScaphealthdown = 0
		_s.SuH_PCScapmagicka += _s.SuH_PCScapmagickadown
		_s.SuH_PCScapmagickadown = 0
		_s.SuH_PCScapstamina += _s.SuH_PCScapstaminadown
		_s.SuH_PCScapstaminadown = 0
		_s.playerRef.UnequipItem(_s.SuH_armor_regalglow, abSilent=true)
		debug.MessageBox("Passives and Actives have been reset and BDSM Rating has been re-calculated.")
	endIf
endFunction 


;	Add Soul Pet
;		Attempts to add the makepetactor into the pet array and enable them for player use, either makepetactor or makepetbase needs to be valid
;		makepetactor	: actor		: the actor to try and add into the pet array
;		bccost			: bool		: while true we'll check for and reduce Blood Chips when adding the actor
;		useditem		: form		: item used to try and add the pet, if failed we try to return this item
;		makepetbase		: actorbase	: attempt to add this actorbase as a pet if makepetactor is invalid
Function SoulPetAdd(Actor makepetactor=none, bool bccost=false, form useditem=none, ActorBase makepetbase=none)

	; Check if Actor is Valid
	if makepetactor != none
		if makepetactor.Isdead()
			Debug.MessageBox(": Soul Pets : \n Dead Characters can't be replicated as a pet.")
			return
		elseif makepetactor.IsInFaction(_s.SuH_petfaction)
			Debug.MessageBox(": Soul Pets : \n Character is already replicated as a pet!")
			return
		elseif makepetactor.IsInFaction(_s.PotentialFollowerFaction)
			Debug.MessageBox(": Soul Pets : \n Followers can't be replicated as a pet.")
			return
		elseif makepetactor.IsInFaction(_s.PlayerPotentialAnimalFaction)
			Debug.MessageBox(": Soul Pets : \n Followers can't be replicated as a pet.")
			return
		endIf
		;	Get Actor Base if Actor is valid
		makepetbase = makepetactor.GetActorBase()
	elseif makepetbase == none ; if no actor or petbase is added
		return
	endIf

	;	Check if Actor Base is valid
	if makepetbase.IsUnique()
		Debug.MessageBox(": Soul Pets : \n Unique NPCs can't be replicated as a pet.")
		return
	endIf
	
	;	Check if character is leveled actor, then get templatebase and replace normal base if true
	ActorBase makepetleveled = makepetactor.getleveledactorbase()
	actorbase templatebase = makepetactor.getleveledactorbase().gettemplate()
	if templatebase != none
		makepetbase = templatebase
	endIf
	
	int i = 0
	int x = 0
	While i == 0 ; Find slot and create pet
		if _s.SuH_petactorbases[x] == none ; if slot is empty
			bool createpet = true
			if bccost == true ; if blood chip cost is enabled, check for blood chips
				if PlayerRef.GetItemCount(_s.SuH_misc_bloodchip) < 80
					createpet = false
					Debug.MessageBox(": Soul Pets : \n Not Enough Blood Chips")
				else
					PlayerRef.RemoveItem(_s.SuH_misc_bloodchip, 80) ; remove blood chip cost
				endIf
			endIf
			if createpet == true ; if we're creating the pet
				_s.SuH_petactorbases[x] = makepetbase
				actor createdpet = _s.SuH_realm_petinitspawn.PlaceActorAtMe(_s.SuH_petactorbases[x], 4)
				_s.SuH_petactoralive[x] = createdpet
				createdpet.RemoveFromAllFactions()
				createdpet.AddToFaction(_s.CurrentFollowerFaction)
				createdpet.SetFactionRank(_s.CurrentFollowerFaction, -1)
				createdpet.AddToFaction(_s.PlayerPotentialAnimalFaction)
				createdpet.AddToFaction(_s.SuH_petfaction)
				createdpet.AddToFaction(_s.SuH_ignoreabsorb)
				createdpet.AddSpell(_s.SuH_spell_pet)
				PetCalculateRandomTrait(x) ; Chance to add a starting trait
				createdpet.Disable()
				_s.SuH_petlevels[x] = 0
				_s.SuH_petxps[x] = 0
				_s.SuH_pettrait0[x] = 0
				_s.SuH_pettrait1[x] = 0
				_s.SuH_pettrait2[x] = 0
				_s.SuH_petnames[x] = ""
				string petname = makepetbase.GetName()
				if petname == ""
					petname = "Pet"
				endIf
				int m = 0 ; search if pet name is already taken
				int k = 0
				while m < _s.SuH_petnames.Length
					if _s.SuH_petnames[m] == petname
						petname = makepetbase.GetName()
						if petname == ""
							petname = "Pet"
						endIf
						k += 1
						petname = petname+k
						m = 0
					else
						m += 1
					endIf
				endWhile
				_s.SuH_petnames[x] = petname
				Debug.MessageBox(": Soul Pets : \n "+petname+" Soul Replicated!")
			endIf
			i = 1
		else ; Slot wasn't empty
			x += 1 ; increase count
		endIf
		if x > 24 ; if reached end of array
			if useditem != none
				PlayerRef.AddItem(useditem, 1, true) ; refund item used
			endIf
			Debug.MessageBox(": Soul Pets : \n No available slots found!")
			i = 1
		endIf
	endWhile
	;else ; if pet did exist
	;	if useditem != none
	;		PlayerRef.AddItem(useditem, 1, true) ; refund item used
	;	endIf
	;	Debug.MessageBox(": Soul Pets : \n Soul of this type already registered!")
	;endIf
endFunction

;	Summon Soul Pet
;		Attempts to summon the determined pet
;		slotnum		: int	: Pet Slot number to summonon
;		petactor	: actor	: actor to attempt to summon if petslot is invalid, slotnum takes priority if valid
Function SoulPetSummon(int slotnum=-1, actor petactor=none)
	if slotnum < 0 ; if slotnum is invalid
		if petactor != none ; if actor provided
			slotnum = PetFindSlot(petactor) ; find pet slot
			if slotnum < 0 ; if slot still invalid
				return ; invalid
			endIf
		else
			return ; invalid
		endIf
	endIf
	actor petactive = _s.SuH_actor_activepet
	if petactive != none && slotnum != _s.SuH_petactive ; If we have an active pet and we're not summoning them, desummon them
		if _s.SuH_SETpetnewsumdismiss > 0 ; if dismiss instead of unsummon setting is enabled
			SoulPetDismiss()
		elseif _s.SexLab.ValidateActor(petactive) == -10 ; if active pet is in a sex act
			debug.MessageBox("Couldn't Unsummon Active Soul Pet, can't be Unsummoned while In-Act")
			return ; fail summon since we can't unsummon pet
		else
			SoulPetDeSummon()
		endIf
	endIf
	_s.SuH_petactive = slotnum ; set active pet slot
	if _s.SuH_petactoralive[slotnum] != none ; If pet is already active / created
		petactive = _s.SuH_petactoralive[slotnum]
		_s.SuH_actor_activepet = petactive
		petactive.Enable()
		petactive.RemoveSpell(_s.SuH_spell_pet) ; reset pet tracking spell
		petactive.AddSpell(_s.SuH_spell_pet)
		PetReapplyTraits(slotnum) ; Reapply traits as need be
	else ; if pet doesn't exist already
		petactive = _s.SuH_realm_petinitspawn.PlaceActorAtMe(_s.SuH_petactorbases[slotnum], 4)
		_s.SuH_actor_activepet = petactive
		_s.SuH_petactoralive[slotnum] = petactive
		petactive.RemoveFromAllFactions()
		petactive.AddToFaction(_s.CurrentFollowerFaction)
		petactive.SetFactionRank(_s.CurrentFollowerFaction, -1)
		petactive.AddToFaction(_s.PlayerPotentialAnimalFaction)
		petactive.AddToFaction(_s.SuH_petfaction)
		petactive.AddToFaction(_s.SuH_ignoreabsorb)
		petactive.AddSpell(_s.SuH_spell_pet)
		PetReapplyTraits(slotnum)
		;_s.SuH_actor_activepet.RemoveAllItems(none, false, true) ; May or may not re-enable this feature to remove items from pets
	endIf
	_s.SuH_petactorbases[slotnum].SetEssential(false)
	_s.SuH_petmostrecentactor = petactive ; set most recent pet
	if _s.SexLab.ValidateActor(petactive) != -10 ; if pet is not in act
		petactive.MoveTo(PlayerRef)
	endIf
	(pDialogueFollower as DialogueFollowerScript).SetAnimal(petactive)
	string petname = _s.SuH_petnames[_s.SuH_petactive]
	Debug.Notification("Soul Pets : "+petname+" has been summoned.")
endFunction

;	Unsummon Soul Pet
;		Attempts to unsummon the determined pet
;		slotnum : int : pet slot to unsummon, if invalid uses SuH_petactive instead, unsummoning the active pet
Function SoulPetDeSummon(int slotnum=-1)
	if slotnum < 0
		if _s.SuH_actor_activepet != none
			slotnum = _s.SuH_petactive
		else
			return ; invalid
		endIf
	endIf
	if _s.SuH_petactoralive[slotnum] != none ; If pet exists
		if _s.SexLab.ValidateActor(_s.SuH_petactoralive[slotnum]) == -10
			debug.MessageBox("Soul Pets can't be Unsummoned while In-Act")
		else
			if slotnum == _s.SuH_petactive ; If slotnum is default or active pet
				slotnum = _s.SuH_petactive ; Ensure slotnum is active slot number
				if _s.SuH_SETpetstayfollowing == 0 ; if stay following is disabled
					(pDialogueFollower as DialogueFollowerScript).DismissAnimal() ; Dismiss pet
				endIf
				_s.SuH_petactive = -1 ; Set Active Pet to none
				_s.SuH_actor_activepet = none
			endIf
			;	If pet has fragile spell, remove it and heal before returning so pet doesn't trigger death
			if _s.SuH_petactoralive[slotnum].HasSpell(_s.SuH_spell_pTraitHealthDown)
				_s.SuH_petactoralive[slotnum].RemoveSpell(_s.SuH_spell_pTraitHealthDown)
				_s.SuH_petactoralive[slotnum].RestoreActorValue("Health", 80)
			endIf
			string petname = _s.SuH_petnames[slotnum]
			_s.SuH_petactoralive[slotnum].MoveTo(_s.SuH_realm_petinitspawn)
			_s.SuH_petactoralive[slotnum].Disable()
			Debug.Notification("Soul Pets : "+petname+" has been returned.")
		endIf
	endIf
endFunction

;	Remove Soul Pet
;		Attempts to remove the determined soul pet
;		petslot : int : pet slot to remove the pet from
Function SoulPetRemove(int petslot)
	if _s.SuH_petactorbases[petslot] != none ; If pet slot isn't empty
		string petname = _s.SuH_petnames[petslot] ; grab pet name for function
		int x = (_s.SuH_petlevels[petslot] * 10) ; Grant blood chips based on pet level
		PlayerRef.AddItem(_s.SuH_misc_bloodchip, x, true)
		;	Clear array entries
		if _s.SuH_petactoralive[petslot] != none ; if active, delete pet
			if _s.SuH_petactoralive[petslot] == _s.SuH_petmostrecentactor
				_s.SuH_petmostrecentactor = none
			endIf
			_s.SuH_petactoralive[petslot].disable()
			_s.SuH_petactoralive[petslot].delete()
			_s.SuH_petactoralive[petslot] = none
		endIf
		_s.SuH_petactorbases[petslot] = none
		_s.SuH_petxps[petslot] = 0
		_s.SuH_petlevels[petslot] = 0
		_s.SuH_petnames[petslot] = ""
		PetCollapseArray()
		Debug.MessageBox(": Soul Pets : \n "+petname+" Pet Removed! "+x+" Blood Chips Harvested.")
	endIf
endFunction

;	Collapse 2D Pet Array
;		Condenses the 2D pet array to avoid empty spaces, allows for hardcoded optimizations and improves overall performance with early fails
Function PetCollapseArray()
	int k = 0 ; empty array position check (move to)
	int i = 0 ; active array position
	while i < _s.SuH_petactorbases.Length
		if _s.SuH_petactorbases[i] != none ; if slot is not empty
			if k == i ; if last empty array check is this position
				k += 1 ; move to next position for check
			else ; if not this slot, adjust
				if i == _s.SuH_petactive ; if slot is active pet
					_s.SuH_petactive = k ; change active pet slot
				endIf
				_s.SuH_petlevels[k] = _s.SuH_petlevels[i]
				_s.SuH_petlevels[i] = 0
				_s.SuH_petxps[k] = _s.SuH_petxps[i]
				_s.SuH_petxps[i] = 0
				_s.SuH_petnames[k] = _s.SuH_petnames[i]
				_s.SuH_petnames[i] = ""
				_s.SuH_petactoralive[k] = _s.SuH_petactoralive[i]
				_s.SuH_petactoralive[i] = none
				_s.SuH_petactorbases[k] = _s.SuH_petactorbases[i]
				_s.SuH_petactorbases[i] = none
				_s.SuH_pettrait0[k] = _s.SuH_pettrait0[i]
				_s.SuH_pettrait0[i] = 0
				_s.SuH_pettrait1[k] = _s.SuH_pettrait1[i]
				_s.SuH_pettrait1[i] = 0
				_s.SuH_pettrait2[k] = _s.SuH_pettrait2[i]
				_s.SuH_pettrait2[i] = 0
				k += 1 ; move to next position for check
			endIf
		endIf
		i += 1
	endWhile
endFunction

;	Dismiss Soul Pet
;		Attempts to dismiss the designated pet, currently always designates the active pet
;		slotnum : int : pet slot to dismiss, corrently unused
Function SoulPetDismiss(int slotnum=-1)
	if _s.SuH_actor_activepet != none
		string petname = _s.SuH_petnames[_s.SuH_petactive]
		if _s.SuH_SETpetstayfollowing == 0 ; if stay following is disabled
			(pDialogueFollower as DialogueFollowerScript).DismissAnimal()
		endIf
		_s.SuH_actor_activepet = none
		_s.SuH_petactive = -1
		Debug.Notification("Soul Pets : "+petname+" has been dismissed.")
	endIf
endFunction

;	Pet Death
;		Function ran on a pet's death
;		petactor : actor : actor pet to run the death code for
Function PetDeath(actor petactor)
	int petslot = -1
	int i = 0
	while i < _s.SuH_petactoralive.Length
		if _s.SuH_petactoralive[i] != none
			if petactor == _s.SuH_petactoralive[i]
				petslot = i
				i = 49 ; escape while
			endIf
		else ; if pet is none
			return ; pet not found
		endIf
		i += 1
	endWhile
	if _s.SuH_SETpetremoveondeath > 0
		SoulPetRemove(petslot)
	else
		_s.SuH_petactoralive[petslot].MoveTo(_s.SuH_realm_petinitspawn)
		_s.SuH_petactoralive[petslot].Resurrect()
		SoulPetDeSummon(petslot)
	endIf
endFunction

;	Add Pet XP
;		Adds XP to the designated pet, includes levelup code
;		petactor	: actor	: pet actor to add the XP to
;		xpgain		: int	: xp amount to add
Function Pet_addXP(actor petactor, int xpgain=0)
	int petslot = -1
	int i = 0
	while i < _s.SuH_petactoralive.Length
		if _s.SuH_petactoralive[i] != none
			if petactor == _s.SuH_petactoralive[i]
				petslot = i
				i = 49 ; escape while
			endIf
		else ; if pet is none
			return ; pet not found
		endIf
		i += 1
	endWhile
	if xpgain < 1 ; if below 1, set xpgained to 1
		xpgain = 1
	endIf
	xpgain = Math.Floor(xpgain * ((_s.SuH_petskill * 0.1) + 1))
	_s.SuH_petxps[petslot] = (_s.SuH_petxps[petslot] + xpgain)
	int xpcost = ((_s.SuH_petlevels[petslot] * 2) * 30 + 20)
	if  _s.SuH_petxps[petslot] >= xpcost ; if enough XP to level pet
		; int x = Math.Floor(_s.SuH_petactoralive[petslot].GetBaseActorValue("Health") + ((_s.SuH_petskill * 0.5) + 5)) ; add 0.5 status per summoning level
		; int y = Math.Floor(_s.SuH_petactoralive[petslot].GetBaseActorValue("Magicka") + ((_s.SuH_petskill * 0.5) + 5))
		; int z = Math.Floor(_s.SuH_petactoralive[petslot].GetBaseActorValue("Stamina") + ((_s.SuH_petskill * 0.5) + 5))
		; _s.SuH_petactoralive[petslot].SetActorValue("Health", x) ; get and set new BaseActorValues
		; _s.SuH_petactoralive[petslot].SetActorValue("Magicka", y)
		; _s.SuH_petactoralive[petslot].SetActorValue("Stamina", z)
		_s.SuH_petxps[petslot] = (_s.SuH_petxps[petslot] - xpcost) ; subtract cost
		_s.SuH_petlevels[petslot] = (_s.SuH_petlevels[petslot] + 1) ; increase level
		PetSumXP((1 + (_s.SuH_petlevels[petslot] * 2))) ; grant summoning skill XP
		PetCalculateRandomTrait(petslot)
		;	Display level message
		Debug.Notification("Soul Pets : "+(_s.SuH_petnames[petslot])+" Level Increased!")
	endIf
endFunction

;	Add Pet Summoner Skill XP
;		Adds XP and level the player summoner/pet skill
;		xpgain	: int	: XP to add
Function PetSumXP(int xpgain=0)
	if xpgain < 1 ; if below 1, set xpgained to 1
		xpgain = 1
	endIf
	_s.SuH_petskillxp += xpgain ; add xp
	int xpcost = Math.Floor((_s.SuH_petskill * 1.8) * 20 + 20)
	if _s.SuH_petskillxp >= xpcost ; if enough for level up, add level
		_s.SuH_petskillxp -= xpcost
		_s.SuH_petskill += 1
		Debug.Notification("Soul Pets : Summoning Level Increased!")
	endIf
endFunction

;	Get Pet Trait Name
;		returns the readable name or description for the desired trait
;		traitnum	: int	: enumerated trait value
;		descrip		: bool	: if true we return the description instead of the name
string Function PetGetTraitName(int traitnum=0, bool descrip=false)
	if traitnum == 0
		return "No Trait"
	endIf
	if traitnum == 1
		if descrip == false
			return "Strong" ; SuH_spell_pTraitHealth
		else ; if returning description
			return "Increases Soul Pet Health by 80. [Does not stack with similar effects]"
		endIf
	elseif traitnum == 2
		if descrip == false
			return "Magical" ; SuH_spell_pTraitMagicka
		else ; if returning description
			return "Increases Soul Pet Magicka by 80. [Does not stack with similar effects]"
		endIf
	elseif traitnum == 3
		if descrip == false
			return "Athletic" ; SuH_spell_pTraitStamina
		else ; if returning description
			return "Increases Soul Pet Stamina by 80. [Does not stack with similar effects]"
		endIf
	elseif traitnum == 4
		if descrip == false
			return "Fragile" ; SuH_spell_pTraitHealthDown
		else ; if returning description
			return "Reduces Soul Pet Health by 80. [Does not stack with similar effects]"
		endIf
	elseif traitnum == 5
		if descrip == false
			return "Anti-Magical" ; SuH_spell_pTraitMagickaDown
		else ; if returning description
			return "Reduces Soul Pet Magicka by 80. [Does not stack with similar effects]"
		endIf
	elseif traitnum == 6
		if descrip == false
			return "Lazy" ; SuH_spell_pTraitStaminaDown
		else ; if returning description
			return "Reduces Soul Pet Stamina by 80. [Does not stack with similar effects]"
		endIf
	elseif traitnum == 7
		if descrip == false
			return "Aggressive Partner"
		else ; if returning description
			return "Soul Pet causes damage to sexual partners' health after the end of an act. [Damage starts at 10, increasing by 4 every Pet Level]"
		endIf
	elseif traitnum == 8
		if descrip == false
			return "Exhausting Partner"
		else ; if returning description
			return "Soul Pet causes massive damage to sexual partners' Magicka and Stamina after the end of an act. [Damage starts at 40, increasing by 10 every Pet Level]"
		endIf
	elseif traitnum == 9
		if descrip == false
			return "Master Cravings"
		else ; if returning description
			return "Soul Pet has a strong desire for your Succubus, randomly lusting onto them."
		endIf
	elseif traitnum == 10
		if descrip == false
			return "Lustful"
		else ; if returning description
			return "Soul Pet has strong desires, randomly lusting onto others."
		endIf
	elseif traitnum == 11
		if descrip == false
			return "Overflowing"
		else ; if returning description
			return "Soul Pet generates more Sexual Fluids than usual, giving more Sexual Fluids to partners."
		endIf
	elseif traitnum == 12
		if descrip == false
			return "Masochist"
		else ; if returning description
			return "Soul Pet loves suffering and gains more XP when hit."
		endIf
	endIf
endFunction

;	Calculate Random Pet Trait
;		Calculates pet trait gain with random probabilities, applying pet traits as needed with PetAddTrait
;		petslot		: int	: pet slot to apply trait to
;		petactor	: actor	: actor to apply trait to if petslot is invalid
Function PetCalculateRandomTrait(int petslot=-1, actor petactor=none)
	if petslot < 0 ; if pet slot is invalid
		if petactor != none ; if petactor is valid
			petslot = PetFindSlot(petactor) ; find pet slot
			if petslot < 0 ; if slot still invalid
				return ; pet invalid
			endIf
		else
			return ; input invalid
		endIf
	endIf
	;	Calculate random trait to add to pet
	if _s.SuH_pettrait2[petslot] == 0 ; if last pet trait slot is empty
		int x = Utility.RandomInt(0, 99) ; get random number for chance
		int y = ((_s.SuH_petlevels[petslot] * 2) + 8) ; Chance is 8 + 2 per level (10% chance when leveling to level 1)
		if _s.SuH_pettrait0[petslot] == 0
			y += 15
		elseif _s.SuH_pettrait1[petslot] == 0
			y += 5
		endIf
		if x < y ; if within chance window
			x = Utility.RandomInt(0,79)
			y = 0
			if x < 10
				y = 1; Strong SuH_spell_pTraitHealth
			elseif x < 20
				y = 2; Magical SuH_spell_pTraitMagicka
			elseif x < 30
				y = 3; Athletic SuH_spell_pTraitStamina
			elseif x < 35
				y = 4; fragile SuH_spell_pTraitHealthDown
			elseif x < 40
				y = 5; anti-magical SuH_spell_pTraitMagickaDown
			elseif x < 45
				y = 6; lazy SuH_spell_pTraitStaminaDown
			elseif x < 50
				y = 7; Aggressive Partner
			elseif x < 55
				y = 8; Exhausting Partner
			elseif x < 60
				y = 9; Master Cravings
			elseif x < 65
				y = 10; Lustful
			elseif x < 75
				y = 11; Overflowing
			elseif x < 80
				y = 12; Masochist
			endIf
			PetAddTrait(petslot, traitnum=y)
		endIf
	endIf
endFunction

;	Add Pet Trait
;		Adds the designated pet trait to the designated pet
;		petslot		: int	: pet slot to add the trait to
;		traitnum	: int	: enumerated trait number to add
Function PetAddTrait(int petslot=-1, int traitnum=0)
	if traitnum == 0 || petslot < 0 ; if petslot or traitnum are invalid
		return
	endIf
	;	if last trait slot is empty (Space for another trait available) and the trait isn't already learned
	if _s.SuH_pettrait2[petslot] == 0 && _s.SuH_pettrait0[petslot] != traitnum && _s.SuH_pettrait1[petslot] != traitnum
		
		;	Place trait, add additional checks if certain traits begin preventing other traits
		if _s.SuH_pettrait0[petslot] == 0 ; Check if slot 0 is valid
			_s.SuH_pettrait0[petslot] = traitnum ; place in slot 0
		elseif _s.SuH_pettrait1[petslot] == 0 ; check if slot 1 is valid
			_s.SuH_pettrait1[petslot] = traitnum ; place in slot 1
		else ; already know slot 2 is valid
			_s.SuH_pettrait2[petslot] = traitnum ; place in slot 2
		endIf
		;	Apply trait effects
		PetReapplyTraits(petslot)
		debug.Notification(_s.SuH_petnames[petslot]+" Learned Trait : "+PetGetTraitName(traitnum))
	endIf
endFunction

;	Reapply Pet Traits
;		Reapllies pet trait spell effects to ensure they're functioning properly
;		petslot : int : pet slot to run the reapply on
Function PetReapplyTraits(int petslot=0)
	int pettrait0 = _s.SuH_pettrait0[petslot]
	int pettrait1 = _s.SuH_pettrait1[petslot]
	int pettrait2 = _s.SuH_pettrait2[petslot]
	
	; Strong SuH_spell_pTraitHealth
	if pettrait0 == 1 || pettrait1 == 1 || pettrait2 == 1
		if pettrait0 == 4 || pettrait1 == 4 || pettrait2 == 4 ; if has fragile
			_s.SuH_petactoralive[petslot].RemoveSpell(_s.SuH_spell_pTraitHealth)
			_s.SuH_petactoralive[petslot].RemoveSpell(_s.SuH_spell_pTraitHealthDown)
		else
			_s.SuH_petactoralive[petslot].AddSpell(_s.SuH_spell_pTraitHealth) ; Add trait spell
			_s.SuH_petactoralive[petslot].RemoveSpell(_s.SuH_spell_pTraitHealthDown)
		endIf
	; fragile SuH_spell_pTraitHealthDown
	elseif pettrait0 == 4 || pettrait1 == 4 || pettrait2 == 4
		_s.SuH_petactoralive[petslot].RemoveSpell(_s.SuH_spell_pTraitHealth)
		_s.SuH_petactoralive[petslot].AddSpell(_s.SuH_spell_pTraitHealthDown)
	else
		_s.SuH_petactoralive[petslot].RemoveSpell(_s.SuH_spell_pTraitHealth)
		_s.SuH_petactoralive[petslot].RemoveSpell(_s.SuH_spell_pTraitHealthDown)
	endIf
	
	; Magical SuH_spell_pTraitMagicka
	if pettrait0 == 2 || pettrait1 == 2 || pettrait2 == 2
		if pettrait0 == 5 || pettrait1 == 5 || pettrait2 == 5 ; if has anti-magical
			_s.SuH_petactoralive[petslot].RemoveSpell(_s.SuH_spell_pTraitMagicka)
			_s.SuH_petactoralive[petslot].RemoveSpell(_s.SuH_spell_pTraitMagickaDown)
		else
			_s.SuH_petactoralive[petslot].AddSpell(_s.SuH_spell_pTraitMagicka) ; Add trait spell
			_s.SuH_petactoralive[petslot].RemoveSpell(_s.SuH_spell_pTraitMagickaDown)
		endIf
	; anti-magical SuH_spell_pTraitMagickaDown
	elseif pettrait0 == 5 || pettrait1 == 5 || pettrait2 == 5
		_s.SuH_petactoralive[petslot].RemoveSpell(_s.SuH_spell_pTraitMagicka)
		_s.SuH_petactoralive[petslot].AddSpell(_s.SuH_spell_pTraitMagickaDown)
	else
		_s.SuH_petactoralive[petslot].RemoveSpell(_s.SuH_spell_pTraitMagicka)
		_s.SuH_petactoralive[petslot].RemoveSpell(_s.SuH_spell_pTraitMagickaDown)
	endIf
	
	; Athletic SuH_spell_pTraitStamina
	if pettrait0 == 3 || pettrait1 == 3 || pettrait2 == 3
		if pettrait0 == 6 || pettrait1 == 6 || pettrait2 == 6 ; if has fragile
			_s.SuH_petactoralive[petslot].RemoveSpell(_s.SuH_spell_pTraitStamina)
			_s.SuH_petactoralive[petslot].RemoveSpell(_s.SuH_spell_pTraitStaminaDown)
		else
			_s.SuH_petactoralive[petslot].AddSpell(_s.SuH_spell_pTraitStamina) ; Add trait spell
			_s.SuH_petactoralive[petslot].RemoveSpell(_s.SuH_spell_pTraitStaminaDown)
		endIf
	; lazy SuH_spell_pTraitStaminaDown
	elseif pettrait0 == 6 || pettrait1 == 6 || pettrait2 == 6
		_s.SuH_petactoralive[petslot].RemoveSpell(_s.SuH_spell_pTraitStamina)
		_s.SuH_petactoralive[petslot].AddSpell(_s.SuH_spell_pTraitStaminaDown)
	else
		_s.SuH_petactoralive[petslot].RemoveSpell(_s.SuH_spell_pTraitStamina)
		_s.SuH_petactoralive[petslot].RemoveSpell(_s.SuH_spell_pTraitStaminaDown)
	endIf
endFunction

;	Find Pet Slot
;		Function that searches for the pet slot of the given pet actor
;		petactor : actor : pet actor from the game world to search for
int Function PetFindSlot(actor petactor=none) ; Only works on actors that are alive, use as convenience function
	if petactor != none
		int i = 0
		while i < _s.SuH_petactoralive.Length
			if petactor == _s.SuH_petactoralive[i]
				return i ; return slot number
			else
				i += 1
			endIf
		endWhile
	else
		return -1 ; pet invalid
	endIf
endFunction

;	Start Animation (Scene_StartThread)
;		Starts an animation with the given actor array, return a validation code to signify if the animation started or not
;		animActor[]	: actor[]	: Array of actors to attempt an animation with
; 		victimActor	: actor		: Actor to set as victim, if none then trigger consensual animation
;		Return Values
;			1		: Sent animation to SexLab with success
;			0		: Failed validity checks
;			< 0		: SexLab Error (add -100 for actor codes)
int Function Scene_StartThread(actor[] animActor, actor victimActor=none)
	if animActor.Length > 1 && animActor.Length < 6; If triggering multi-actor animationwith array between 2-5
		
		int mCount = 0
		int fCount = 0
		int mCreCount = 0
		int fCreCount = 0
		int victimGender = -1
		
		int[] animActorGen = new int[5]
		
		;	Validate Array
		bool validarray = true
		int i = 0
		while i < animActor.Length
			bool collapseArray = false
			if animActor[i] != none && _s.Sexlab.ValidateActor(animActor[i]) > 0 ; if actor valid
				
				;	Set Gender Data
				int x = _s.SexLab.GetGender(animActor[i]) ; grab gender
				animActorGen[i] = x ; set gender in gender array
				if animActor[i] == victimActor ; if victim actor
					victimGender = x ; set victim gender
				endIf
				if x == 0 ; if male
					mCount += 1
				elseif x == 1 ; if female
					fCount += 1
				elseif x == 2 ; if male creature
					mCreCount += 1
				elseif x == 3 ; if female creature
					fCreCount += 1
				else
					collapseArray = true
					i -= 1 ; inverse i += 1
				endIf
				i += 1
			else ; if invalid
				collapseArray = true
			endIf
			if collapseArray == true
				if animActor.Length > 2 ; if enough actors to collapse array and keep multi-anim
					;	Create new array
					int newArrayLength = (animActor.Length - 1) 
					actor[] adjustArray ; temp array we will use to move actors
					if newArrayLength == 4
						adjustArray = new actor[4]
					elseIf newArrayLength == 3
						adjustArray = new actor[3]
					else ; newArrayLength == 2
						adjustArray = new actor[2]
					endIf
					;	Fill Temp Array
					if i < 1 ; if replacing slot0
						adjustArray[0] = animActor[1]
					else
						adjustArray[0] = animActor[0]
					endIf
					if i < 2 ; if replacing slot0-1
						adjustArray[1] = animActor[2]
					else
						adjustArray[1] = animActor[1]
					endIf
					if i < 3 ; if replacing slot0-2
						adjustArray[2] = animActor[3]
					else
						adjustArray[2] = animActor[2]
					endIf
					if i < 4 ; if replacing slot0-3
						adjustArray[3] = animActor[4]
					else
						adjustArray[3] = animActor[3]
					endIf
					;	Create new animActor Array
					if newArrayLength == 4
						animActor = new actor[4]
					elseif newArrayLength == 3
						animActor = new actor[3]
					else ; newArrayLength == 2
						animActor = new actor[2]
					endIf
					;	Fill new animActor array from temp array
					animActor[0] = adjustArray[0]
					animActor[1] = adjustArray[1]
					animActor[2] = adjustArray[2]
					animActor[3] = adjustArray[3]
					;	Do not increase i so slot can be re-tested (Array Length is reduced by 1, advancing while loop by 1)
				else ; array is invalid
					validarray = false
					i = 999
				endIf
			endIf
		endWhile
		
		if validarray == false ; if array wasn't valid
			return 0 ; failed
		endIf
		
		sslBaseAnimation[] animSET ; animation set to use
		
		;	Run animation
		i = 0
		while animActor.Length > 1 || i < 4 ; Attempt to start scene with up-to 5 actors
			if fCount == 0 && fCreCount == 0 ; if no female actors
				if _s.SuH_SETallowmalehomo == 1 ; if allow male homo
					if mCreCount > 0 ; if male creatures present
						int x ; slot to use race of
						i = 0 ; find first male creature
						while i < animActor.Length
							if animActorGen[i] == 2 ; if male creature
								x = i
								i = 999 ; exit loop
							else
								i += 1
							endIf
						endWhile
						animSET = _s.SexLab.GetCreatureAnimationsByRaceGenders(animActor.Length, animActor[x].getleveledactorbase().GetRace(), mCreCount, 0, false) ; set anim list
					else ; no creatures
						animSET = _s.SexLab.GetAnimationsByTags(animActor.Length, "", "", false)
					endIf
				else
					return 0 ; failed
				endIf
			elseif mCount == 0 && mCreCount == 0 ; if no male actors
				if _s.SuH_SETallowfemalehomo == 1 ; if allow female homo
					if fCreCount > 0 ; if female creatures present
						int x ; slot to use race of
						i = 0 ; fine first female creature
						while i < animActor.Length
							if animActorGen[i] == 3 ; if female creature
								x = i
								i = 999 ; exit loop
							else
								i += 1
							endIf
						endWhile
						animSET = _s.SexLab.GetCreatureAnimationsByRaceGenders(animActor.Length, animActor[x].getleveledactorbase().GetRace(), 0, fCreCount, false) ; set anim list
					else ; no creatures
						animSET = _s.SexLab.GetAnimationsByTags(animActor.Length, "", "", false)
					endIf
				else
					return 0 ; failed
				endIf
			elseif mCreCount > 0 || fCreCount > 0 ; mixed, with creatures
				int x ; which slot to grab race from
				int k = 0
				while k < animActor.Length ; find first creature
					if animActorGen[k] == 2 || animActorGen[k] == 3
						x = k
						k = 999 ; exit loop
					else
						k += 1
					endIf
				endWhile
				
				string excludetags = ""
				if _s.SuH_SETallowmalehomo == 0 ; if exclude male homo
					excludetags += "gay, "
				endIf
				if _s.SuH_SETallowfemalehomo == 0 ; if exclude female homo
					excludetags += "lesbian, "
				endIf
				animSET = _s.SexLab.GetCreatureAnimationsByRaceGendersTags(animActor.Length, animActor[x].getleveledactorbase().GetRace(), mCreCount, fCreCount, "", excludetags, false)
			else ; mixed, no creatures
				string includetags = ""
				if animActor.Length == 2 && _s.SuH_SETrestrictact > 0 && victimGender == 0 ; if victim is one of the males
					includetags += "cowgirl, "
				endIf
				string excludetags = ""
				if _s.SuH_SETallowmalehomo == 0 ; if exclude male homo
					excludetags += "gay, "
				endIf
				if _s.SuH_SETallowfemalehomo == 0 ; if exclude female homo
					excludetags += "lesbian, "
				endIf
				animSET = _s.SexLab.GetAnimationsByTags(animActor.Length, includetags, excludetags, false)
			endIf
			
			if validarray == true
				int x = _s.SexLab.StartSex(animActor, animSET, victim=victimActor)
				if x < 0 ; if anim failed
					if _s.SuH_SETpreventactdeath > 0
						animActor[0].EndDeferredKill()
						animActor[1].EndDeferredKill()
						animActor[2].EndDeferredKill()
						animActor[3].EndDeferredKill()
						animActor[4].EndDeferredKill()
					endIf
					validarray == false
				else ; if anim started
					return x ; success
				endIf
			endIf
			
			if validarray == false ; if invalid, cull last array entry to try again
				if animActor.Length == 5
					actor[] adjustArray = new actor[4] ; use temp array to transfer data
					adjustArray[0] = animActor[0]
					adjustArray[1] = animActor[1]
					adjustArray[2] = animActor[2]
					adjustArray[3] = animActor[3]
					animActor = new actor[4] ; make new smaller array and transfer data from old array
					animActor[0] = adjustArray[0]
					animActor[1] = adjustArray[1]
					animActor[2] = adjustArray[2]
					animActor[3] = adjustArray[3]
					if animActorGen[4] == 0 ; Remove gender count from culled slot
						mCount -= 1
					elseif animActorGen[4] == 1
						fCount -= 1
					elseif animActorGen[4] == 2
						mCreCount -= 1
					elseif animActorGen[4] == 3
						fCreCount -= 1
					endIf
				elseif animActor.Length == 4
					actor[] adjustArray = new actor[3] ; use temp array to transfer data
					adjustArray[0] = animActor[0]
					adjustArray[1] = animActor[1]
					adjustArray[2] = animActor[2]
					animActor = new actor[3] ; make new smaller array and transfer data from old array
					animActor[0] = adjustArray[0]
					animActor[1] = adjustArray[1]
					animActor[2] = adjustArray[2]
					if animActorGen[3] == 0 ; Remove gender count from culled slot
						mCount -= 1
					elseif animActorGen[3] == 1
						fCount -= 1
					elseif animActorGen[3] == 2
						mCreCount -= 1
					elseif animActorGen[3] == 3
						fCreCount -= 1
					endIf
				elseif animActor.Length == 3
					actor[] adjustArray = new actor[2] ; use temp array to transfer data
					adjustArray[0] = animActor[0]
					adjustArray[1] = animActor[1]
					animActor = new actor[2] ; make new smaller array and transfer data from old array
					animActor[0] = adjustArray[0]
					animActor[1] = adjustArray[1]
					if animActorGen[2] == 0 ; Remove gender count from culled slot
						mCount -= 1
					elseif animActorGen[2] == 1
						fCount -= 1
					elseif animActorGen[2] == 2
						mCreCount -= 1
					elseif animActorGen[2] == 3
						fCreCount -= 1
					endIf
				else
					return 0 ; failed
				endIf
			endIf
			i += 1
		endWhile
		return 0 ; if while ran through 5 times, error out and fail
		
	elseif animActor.Length == 1 ; If triggering Solo Animation
		actor soloactor = animActor[0]
		if soloactor != none && _s.Sexlab.ValidateActor(soloactor) > 0 ; If actor is valid
			sslBaseAnimation[] animSET
			int x = _s.SexLab.GetGender(soloactor) ; get gender of actor
			if x == 0 ; if solo is male
				animSET = _s.Sexlab.GetAnimationsByType(1, 1, 0) ; 1 actor, 1 male, 0 female
			elseif x == 1 ; if solo is female
				animSET = _s.Sexlab.GetAnimationsByType(1, 0, 1) ; 1 actor, 0 male, 1 female
			elseif x == 2 ; if solo is male creature
				animSET = _s.Sexlab.GetCreatureAnimationsByRaceGenders(1, soloactor.GetActorBase().GetRace(), 1, 0) ; 1 actor, getrace, 1 male cre, 0 female cre
			elseif x == 3 ; if solo is female creature
				animSET = _s.Sexlab.GetCreatureAnimationsByRaceGenders(1, soloactor.GetActorBase().GetRace(), 0, 1) ; 1 actor, getrace, 0 male cre, 1 female cre
			endIf
			x = _s.Sexlab.StartSex(animActor, animSET) ; start animation
			if x < 0 ; if anim failed
				if _s.SuH_SETpreventactdeath > 0
					animActor[0].EndDeferredKill()
				endIf
			else ; if anim started
				return x ; success
			endIf
		endIf
		return 0 ; failed
	else ; if array count was invalid
		return 0 ; failed
	endIf
		return 0 ; failed?
endFunction

;	DOM Respawn
;		Runs the respawn check and code for Death Override Mode
;		Return values
;			1 : succeeded
;			0 : failed
int Function SDrespawn()
	if _s.SuH_CHKdied > 0 && _s.Sexlab.ValidateActor(playerRef) != -10; if DOM is waiting for respawn and player isn't in act
		PlayerRef.SetNoBleedoutRecovery(false) ; turn off bleedout and recover status for respawn
		playerRef.RestoreActorValue("Health", 999999999)
		playerRef.RestoreActorValue("Magicka", 999999999)
		playerRef.RestoreActorValue("Stamina", 999999999)
		
		if _s.SuH_SETneverdiemode == 0 ; if neverdiemode is enabled, don't move/respawn player normally
			_s.SuH_sd_returnpoint.MoveTo(PlayerRef) ; move 'directly back' return point
			PlayerRef.MoveTo(_s.SuH_sevaspawn) ; move player to Succubus Realm
		endIf
		
		;	calculate item loss
		_s.SuH_sd_lostchest.RemoveItem(_s.Gold001, 99999999) ; delete any holding gold
		if _s.SuH_SETsdloseequip > 0 ; if destroy equipped is enabled
			int itempoints = 0 ; points from equipment to turn into HeartXP
			Form handequip = PlayerRef.GetEquippedObject(0) ; left hand
			if (handequip)
				itempoints += Math.Floor((handequip.GetWeight() * 250 ) + (handequip.GetGoldValue() * 2))
				PlayerRef.RemoveItem(handequip, 1, true)
			endIf
			handequip = PlayerRef.GetEquippedObject(1) ; right hand
			if (handequip)
				itempoints += Math.Floor((handequip.GetWeight() * 250 ) + (handequip.GetGoldValue() * 2))
				PlayerRef.RemoveItem(handequip, 1, true)
			endIf
			int slotsChecked ; scan slots and destroy things, one by one! MUHA HA HA hah ha...
			slotsChecked += 0x00100000
			slotsChecked += 0x00200000 ;ignore reserved slots
			slotsChecked += 0x80000000
			int thisSlot = 0x01
			while (thisSlot < 0x80000000) ; if out of equip range
				if(Math.LogicalAnd(slotsChecked, thisSlot) != thisSlot) ;Only check un-checked lots
					Armor thisArmor = PlayerRef.GetWornForm(thisSlot) as Armor
					if (thisArmor) ; if armor found
						slotsChecked += thisArmor.GetSlotMask() ;add slots to slotsChecked
						itempoints += Math.Floor((thisArmor.GetWeight() * 250 ) + (thisArmor.GetGoldValue() * 2))
						PlayerRef.RemoveItem(thisArmor, 1, true)
					else ; No armor found
						slotsChecked += thisSlot
					endIf
				endIf
				thisSlot *= 2 ; double hex and move to the next slot
			endWhile
			if itempoints > 0 ; if we need to calculate HeartXP earned
				int xpconvert = Math.Floor(itempoints * 0.1)
				xpconvert = PC_addHeartXP(xpconvert)
				debug.MessageBox(": Death Override Mode :\nEquipment Destroyed, "+xpconvert+" HeartXP granted")
			endIf
		endIf
		if _s.SuH_SETsdloseitems > 0 ; if lose items enabled
			if _s.SuH_SETsdlosegold == 0 ; if lose gold is disabled, put it in holding
				PlayerRef.RemoveItem(_s.Gold001, 999999999, true, _s.SuH_sd_goldchest)
			endIf
			if _s.SuH_SETsdlosebloodchips  == 0 ; if lose blood chips is disabled, put it in holding
				PlayerRef.RemoveItem(_s.SuH_misc_bloodchip, 999999999, true, _s.SuH_sd_goldchest)
			endIf
			PlayerRef.RemoveAllItems(_s.SuH_sd_lostchest, true) ; remove all items
			if _s.SuH_SETsdlosegold == 0 ; restore gold if in holding
				_s.SuH_sd_goldchest.RemoveItem(_s.Gold001, 999999999, true, PlayerRef)
			endIf
			if _s.SuH_SETsdlosebloodchips == 0; restore blood chips if in holding
				_s.SuH_sd_goldchest.RemoveItem(_s.SuH_misc_bloodchip, 999999999, true, PlayerRef)
			endIf
		else ; if lose items is disabled
			if _s.SuH_SETsdlosegold > 0 ; if lose gold is enabled
				PlayerRef.RemoveItem(_s.Gold001, 999999999, true) ; remove gold
			endIf
			if _s.SuH_SETsdlosebloodchips > 0 ; if lose blood chips is enabled
				PlayerRef.RemoveItem(_s.SuH_misc_bloodchip, 999999999, true) ; remove blood chips
			endIf
		endIf
		;	Calculate Revive Cost
		if _s.SuH_SETrevivecost > 0.0 ; if revive cost is enabled
			float divider = (1 - (_s.SuH_SETrevivecost)) ; Invert Percentage
			float x = Math.Floor(PlayerRef.GetBaseActorValue("health") * divider) ;Get New Status
			if x < 1 ; Check if not 0 or negative
				x = 1 ; Set to 1 if 0 or negative
			endIf
			PlayerRef.SetActorValue("health", x) ; Apply new value
			x = Math.Floor(PlayerRef.GetBaseActorValue("magicka") * divider)
			if x < 1
				x = 1
			endIf
			PlayerRef.SetActorValue("magicka", x)
			x = Math.Floor(PlayerRef.GetBaseActorValue("stamina") * divider)
			if x < 1
				x = 1
			endIf
			PlayerRef.SetActorValue("stamina", x)
		endIf
		_s.SuH_CHKdied = 0
		_s.SuH_CHKsdinact = 0
		PlayerRef.SetNoBleedoutRecovery(true) ; reset no bleedout recovery
		_s.SuH_CHKsdrespawn = 1 ; Set forced respawn check
		return 1 ; succeeded
	else
		return 0 ; failed
	endIf
endFunction

;	Offering Get Item
string Function Offer_GetItem(int maxitemcount = 3)
	string notifbuild = ""
	bool rolledLost = false ; set if we rolled a lost item to false
	int lostcount = _s.SuH_sd_lostchest.GetNumItems() ; get item count lost to DOM
	if lostcount == 1
		if _s.SuH_sd_lostchest.GetNthForm(0) == _s.Gold001 as form
			lostcount = 0
		endIf
	endIf
	if lostcount > 0 ; if lost items to DOM, we'll roll to re-aquire items from this chest
		int i = 0
		while i < maxitemcount ; roll for 3 items before moving on
			int rand = Utility.RandomInt(0,(lostcount - 1)) ; get random item from lost chest
			form formfound = _s.SuH_sd_lostchest.GetNthForm(rand)
			if formfound != _s.Gold001 as form
				int pointcost = formfound.GetGoldValue() ; get random item's gold cost as point cost
				if _s.SuH_PCSofferpoints > pointcost ; if we have enough points
					if pointcost == 0 ; if point cost is 0 we force count to 1 to avoid dividing by 0
						pointcost = 1
					endIf
					int vx = (_s.SuH_PCSofferpoints / pointcost) ; get count possible by points
					int vy = _s.SuH_sd_lostchest.GetItemCount(formfound) ; get count of item stored
					if vy < vx ; if more items are in lost chest, then set max count to chest count
						vx = vy
					endIf
					_s.SuH_sd_lostchest.removeitem(formfound, vx, false, _s.PlayerRef) ; Move reward item to player
					_s.SuH_PCSofferpoints -= (pointcost * vx) ; remove point cost
					rolledLost = true ; set we rolled a lost item (so don't roll again for a new item)
					lostcount -= 1
					notifbuild += ("\nReturned "+formfound.GetName()+" x"+vx)
				endIf
			endIf
			i += 1
		endWhile
	endIf
	;	If we didn't roll a lostchest item
	if rolledLost == false
		form formfound = none ; form to add to player
		int itemcount = 0 ; item count to reward player
		;	Roll for a random Succubus Heart item based on points available
		int vx = _s.SuH_PCSofferpoints
		if vx > 999 ; if 1000 or more points
			int rand = Utility.RandomInt(0,73) ; Randomly roll an item to reward, add 5 as a nothing roll
			if rand < 15
				formfound = _s.SuH_ing_milk as form
				itemcount = 10
			elseif rand < 20
				formfound = _s.SuH_ing_milkcreature as form
				itemcount = 10
			elseif rand < 35
				formfound = _s.SuH_ing_sperm as form
				itemcount = 10
			elseif rand < 40
				formfound = _s.SuH_ing_spermcreature as form
				itemcount = 10
			elseif rand < 45
				formfound = _s.SuH_ing_soulofexperience as form
				itemcount = 3
			elseif rand < 50
				formfound = _s.SuH_ing_soulofforce as form
				itemcount = 3
			elseif rand < 55
				formfound = _s.SuH_ing_souloflife as form
				itemcount = 3
			elseif rand < 60
				formfound = _s.SuH_ing_soulofmagic as form
				itemcount = 3
			elseif rand < 65
				formfound = _s.SuH_ing_soulofpower as form
				itemcount = 3
			elseif rand < 66
				formfound = _s.SuH_ing_empowermentstone as form
				itemcount = 1
			elseif rand < 67
				formfound = _s.SuH_ing_refreshstone as form
				itemcount = 1
			elseif rand < 68
				formfound = _s.SuH_ing_specialtystone as form
				itemcount = 1
			elseif rand < 69
				formfound = _s.SuH_ing_vitalitystone as form
				itemcount = 1
			endIf
		elseif vx > 200 ; if 200 or more points
			int rand = Utility.RandomInt(0,69) ; Randomly roll an item to reward, add 5 as a nothing roll
			if rand < 15
				formfound = _s.SuH_ing_milk as form
				itemcount = 5
			elseif rand < 20
				formfound = _s.SuH_ing_milkcreature as form
				itemcount = 5
			elseif rand < 35
				formfound = _s.SuH_ing_sperm as form
				itemcount = 5
			elseif rand < 40
				formfound = _s.SuH_ing_spermcreature as form
				itemcount = 5
			elseif rand < 45
				formfound = _s.SuH_ing_soulofexperience as form
				itemcount = 1
			elseif rand < 50
				formfound = _s.SuH_ing_soulofforce as form
				itemcount = 1
			elseif rand < 55
				formfound = _s.SuH_ing_souloflife as form
				itemcount = 1
			elseif rand < 60
				formfound = _s.SuH_ing_soulofmagic as form
				itemcount = 1
			elseif rand < 65
				formfound = _s.SuH_ing_soulofpower as form
				itemcount = 1
			endIf
		elseif vx > 30 ; if 30 or more points
			int rand = Utility.RandomInt(0,44) ; Randomly roll an item to reward, add 5 as a nothing roll
			if rand < 15
				formfound = _s.SuH_ing_milk as form
				itemcount = 1
			elseif rand < 20
				formfound = _s.SuH_ing_milkcreature as form
				itemcount = 1
			elseif rand < 35
				formfound = _s.SuH_ing_sperm as form
				itemcount = 1
			elseif rand < 40
				formfound = _s.SuH_ing_spermcreature as form
				itemcount = 1
			endIf
		endIf
			
		if formfound != none
			int pointcost = formfound.GetGoldValue()
			_s.SuH_PCSofferpoints -= (pointcost * itemcount)
			_s.PlayerRef.AddItem(formfound, itemcount)
			notifbuild += ("\nRewarded "+formfound.GetName()+" x"+itemcount)
		endIf
	endIf
	if _s.SuH_PCSofferpoints < 0
		_s.SuH_PCSofferpoints = 0
	endIf
	return notifbuild
endFunction

;	Tali's Replicate Get Cost
;		Get the talirepoints needed for an item
;		reitem : form of the item to check replicate cost
int function Replicate_Cost(form reitem)
	int goldv = Math.Floor(reitem.GetGoldValue())
	int weightv = Math.Floor(reitem.GetWeight())
	int pointcost = 0
	pointcost = math.floor((goldv * 12) + (reitem.GetWeight() * 48) + 6) ; with no levelups, 2 gold += 1 day, 0.5 weight += 1 day, + 6 hours always
	if reitem.haskeyword(_s.SuH_keyword)
		pointcost = (pointcost * 20)
	endIf
	return pointcost
endFunction

;	Tali's Replicate Run Calc
;		Run the calculation to add talirepoints and see if Tali replicated an item or not, if item replicated find a new item to replicate from the chest.
function Replicate_RunCalc()

	;	get time change, only apply if above 1 hour change as changes are calculated per-hour
	int timechange = math.floor((Utility.GetCurrentGameTime() * 24) - _s.SuH_realm_talitimelast)
	
	if timechange > 0 ; if there was a time change
		_s.SuH_realm_talitimelast += timechange ; set last time before we continue
		int repoints = 0
		
		;	Check if we have a form to replicate in the chest, if so we add points, otherwise we make points zero
		int chestitemcount = _s.SuH_cont_repchest.GetNumItems()
		if chestitemcount > 0
			if chestitemcount > 1 || chestitemcount == 1 && _s.SuH_cont_repchest.GetNthForm(0) != _s.Gold001 ; if not only gold in chest
				repoints = _s.SuH_realm_talirepoints
				;	Calculate addition of repoints by each boost condition
				if _s.SuH_realm_taliboost >= _s.SuH_realm_talitoollvl ; full x2 boost if we have blood chips stored
					repoints += (timechange * (_s.SuH_realm_talitoollvl * 2))
					_s.SuH_realm_taliboost -= _s.SuH_realm_talitoollvl
				elseif _s.SuH_realm_taliboost > 0 ; smaller boost if blood chips smaller than level
					repoints += (timechange * (_s.SuH_realm_talitoollvl + _s.SuH_realm_taliboost))
					_s.SuH_realm_taliboost = 0
				else ; no boost with no blood chips stored
					repoints += (timechange * _s.SuH_realm_talitoollvl)
				endif
			endIf
		endIf
		
		;	if we have repoints then run a loop to find items to replicate with said points and build them up
		if repoints > 0
			;	while we have items to get, loop until we have 3 loops (should do validated loops, but this will run faster and I'm lazy)
			int i = 0
			while i < 3
				if _s.SuH_realm_talireitem == none ; if not replicating an item yet, find one
					chestitemcount = _s.SuH_cont_repchest.GetNumItems() ; find item count in chest
					if chestitemcount > 0 ; if we have found items in chest
						int randomfindnum = Utility.RandomInt(0,(chestitemcount - 1))
						form randomfind = _s.SuH_cont_repchest.GetNthForm(randomfindnum)
						
						; Gold Check
						if randomfind == _s.Gold001 ; if found item is gold, try to skip it
							if chestitemcount > 1
								randomfindnum += 1
								if randomfindnum > chestitemcount
									randomfindnum = 0
								endIf
								_s.SuH_realm_talireitem = _s.SuH_cont_repchest.GetNthForm(randomfindnum) ; set item we found to replicate
							else ; if gold is the only item in the chest, purge item and act like we found nothing, exiting loop
								repoints = 0
								i == 999
							endIf
						else ; item wasn't Gold001
							_s.SuH_realm_talireitem = _s.SuH_cont_repchest.GetNthForm(randomfindnum) ; set item we found to replicate
						endif
					else ; if no items in chest, set no points and exit loop
						repoints = 0
						i = 999 ; escape while
					endIf
				endIf
				
				; if we have an item to replicate
				if _s.SuH_realm_talireitem != none
					int recost = Replicate_Cost(_s.SuH_realm_talireitem) ; get cost
					if repoints > recost
						_s.SuH_sd_lostchest.AddItem(_s.SuH_realm_talireitem)
						repoints -= recost
						debug.Notification("Tali replicated a "+_s.SuH_realm_talireitem.GetName()+" and added it to her shop")
						_s.SuH_realm_talireitem = none
					endIf
				else ; no item, reset progress and exit loop since we didn't find an item in the last process
					repoints = 0
					i = 999 ; exit loop
				endIf
				i += 1
			endWhile
		endIf
		_s.SuH_realm_talirepoints = repoints
	endIf
endFunction
